/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.renderering;

import com.trivago.cluecumber.engine.constants.ChartConfiguration;
import com.trivago.cluecumber.engine.constants.Settings;
import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.json.pojo.Step;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.engine.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.engine.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.engine.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllStepsPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;

public class AllStepsPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public AllStepsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllStepsPageCollection allStepsPageCollection, Template template) throws CluecumberException {
        this.addChartJsonToReportDetails(allStepsPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == Settings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(allStepsPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, allStepsPageCollection, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(AllStepsPageCollection allTagsPageCollection) {
        ArrayList<Float> passed = new ArrayList<Float>();
        ArrayList<Float> failed = new ArrayList<Float>();
        ArrayList<Float> skipped = new ArrayList<Float>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Step, ResultCount> entry : allTagsPageCollection.getStepResultCounts().entrySet()) {
            ResultCount stepResultCount = entry.getValue();
            passed.add(Float.valueOf(stepResultCount.getPassed()));
            failed.add(Float.valueOf(stepResultCount.getFailed()));
            skipped.add(Float.valueOf(stepResultCount.getSkipped()));
            if (stepResultCount.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = stepResultCount.getTotal();
        }
        List<String> keys = allTagsPageCollection.getStepResultCounts().keySet().stream().map(Step::returnNameWithArgumentPlaceholders).collect(Collectors.toList());
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allTagsPageCollection.getTotalNumberOfSteps() + " Steps").setyAxisStepSize(maximumNumberOfRuns).setyAxisLabel("Number of Usages").addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allTagsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

