/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.renderering;

import com.trivago.cluecumber.engine.constants.ChartConfiguration;
import com.trivago.cluecumber.engine.constants.Settings;
import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.json.pojo.Tag;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.charts.ChartJsonConverter;
import com.trivago.cluecumber.engine.rendering.pages.charts.StackedBarChartBuilder;
import com.trivago.cluecumber.engine.rendering.pages.charts.pojos.Chart;
import com.trivago.cluecumber.engine.rendering.pages.pojos.ResultCount;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllTagsPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.PageWithChartRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class AllTagsPageRenderer
extends PageWithChartRenderer {
    private final ChartConfiguration chartConfiguration;
    private final PropertyManager propertyManager;

    @Inject
    public AllTagsPageRenderer(ChartJsonConverter chartJsonConverter, ChartConfiguration chartConfiguration, PropertyManager propertyManager) {
        super(chartJsonConverter);
        this.chartConfiguration = chartConfiguration;
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllTagsPageCollection allTagsPageCollection, Template template) throws CluecumberException {
        this.addChartJsonToReportDetails(allTagsPageCollection);
        if (this.propertyManager.getCustomParametersDisplayMode() == Settings.CustomParamDisplayMode.ALL_PAGES) {
            this.addCustomParametersToReportDetails(allTagsPageCollection, this.propertyManager.getCustomParameters());
        }
        return this.processedContent(template, allTagsPageCollection, this.propertyManager.getNavigationLinks());
    }

    private void addChartJsonToReportDetails(AllTagsPageCollection allTagsPageCollection) {
        ArrayList<Float> passed = new ArrayList<Float>();
        ArrayList<Float> failed = new ArrayList<Float>();
        ArrayList<Float> skipped = new ArrayList<Float>();
        int maximumNumberOfRuns = 0;
        for (Map.Entry<Tag, ResultCount> entry : allTagsPageCollection.getTagResultCounts().entrySet()) {
            ResultCount tagResultCount = entry.getValue();
            passed.add(Float.valueOf(tagResultCount.getPassed()));
            failed.add(Float.valueOf(tagResultCount.getFailed()));
            skipped.add(Float.valueOf(tagResultCount.getSkipped()));
            if (tagResultCount.getTotal() <= maximumNumberOfRuns) continue;
            maximumNumberOfRuns = tagResultCount.getTotal();
        }
        ArrayList<String> keys = new ArrayList<String>();
        for (Tag tag : allTagsPageCollection.getTagResultCounts().keySet()) {
            keys.add(tag.getName());
        }
        Chart chart = new StackedBarChartBuilder(this.chartConfiguration).setLabels(keys).setxAxisLabel(allTagsPageCollection.getTotalNumberOfTags() + " Tags").setyAxisLabel("Number of Scenarios").setyAxisStepSize(maximumNumberOfRuns).addValues(passed, Status.PASSED).addValues(failed, Status.FAILED).addValues(skipped, Status.SKIPPED).build();
        allTagsPageCollection.getReportDetails().setChartJson(this.convertChartToJson(chart));
    }
}

