/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.visitors;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllFeaturesPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.TreeViewPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.engine.rendering.pages.visitors.PageVisitor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FeatureVisitor
implements PageVisitor {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final AllFeaturesPageRenderer allFeaturesPageRenderer;
    private final AllScenariosPageRenderer allScenariosPageRenderer;
    private final TreeViewPageRenderer treeViewPageRenderer;

    @Inject
    public FeatureVisitor(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, AllFeaturesPageRenderer allFeaturesPageRenderer, AllScenariosPageRenderer allScenariosPageRenderer, TreeViewPageRenderer treeViewPageRenderer) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.allFeaturesPageRenderer = allFeaturesPageRenderer;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
        this.treeViewPageRenderer = treeViewPageRenderer;
    }

    @Override
    public void visit(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberException {
        AllFeaturesPageCollection allFeaturesPageCollection = new AllFeaturesPageCollection(allScenariosPageCollection.getReports(), this.propertyManager.getCustomPageTitle());
        this.fileIO.writeContentToFile(this.allFeaturesPageRenderer.getRenderedContent(allFeaturesPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_FEATURES)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/feature-summary.html");
        for (Feature feature : allFeaturesPageCollection.getFeatures()) {
            this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContentByFeatureFilter(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_SCENARIOS), feature), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/feature-scenarios/feature_" + feature.getIndex() + ".html");
        }
        this.fileIO.writeContentToFile(this.treeViewPageRenderer.getRenderedContent(allFeaturesPageCollection, allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.TREE_VIEW)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/tree-view.html");
    }
}

