/*
 * Copyright 2023 trivago N.V.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.trivago.cluecumber.engine.rendering.pages.visitors;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;

/**
 * Base interface for page collections to accept visitor classes.
 */
public interface Visitable {
    /**
     * The method to accept a visitor.
     *
     * @param visitor The {@link PageVisitor} instance.
     * @throws CluecumberException Thrown on any error.
     */
    void accept(final PageVisitor visitor) throws CluecumberException;
}
