/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.constants;

import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ChartConfiguration {
    private final PropertyManager propertyManager;
    private String passedColorRgbaString;
    private String failedColorRgbaString;
    private String skippedColorRgbaString;

    @Inject
    public ChartConfiguration(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public String getColorRgbaStringByStatus(Status status) {
        switch (status) {
            case FAILED: {
                return this.getFailedColorRgbaString();
            }
            case SKIPPED: {
                return this.getSkippedColorRgbaString();
            }
        }
        return this.getPassedColorRgbaString();
    }

    public String getPassedColorRgbaString() {
        if (this.passedColorRgbaString == null) {
            this.passedColorRgbaString = this.getRgbaColorStringFromHex(this.propertyManager.getCustomStatusColorPassed());
        }
        return this.passedColorRgbaString;
    }

    public String getFailedColorRgbaString() {
        if (this.failedColorRgbaString == null) {
            this.failedColorRgbaString = this.getRgbaColorStringFromHex(this.propertyManager.getCustomStatusColorFailed());
        }
        return this.failedColorRgbaString;
    }

    public String getSkippedColorRgbaString() {
        if (this.skippedColorRgbaString == null) {
            this.skippedColorRgbaString = this.getRgbaColorStringFromHex(this.propertyManager.getCustomStatusColorSkipped());
        }
        return this.skippedColorRgbaString;
    }

    private String getRgbaColorStringFromHex(String hexColorString) {
        if (hexColorString == null || hexColorString.isEmpty()) {
            return "";
        }
        String hex = hexColorString;
        if (hex.startsWith("#")) {
            hex = hex.substring(1);
        }
        int[] rgbEntries = new int[]{Integer.parseInt(hex.substring(0, 2), 16), Integer.parseInt(hex.substring(2, 4), 16), Integer.parseInt(hex.substring(4, 6), 16)};
        return String.format("rgba(%d, %d, %d, 1.000)", rgbEntries[0], rgbEntries[1], rgbEntries[2]);
    }

    public static enum Type {
        bar,
        pie;

    }
}

