/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.constants;

import java.util.Arrays;
import java.util.List;
import java.util.Set;

public enum Status {
    PASSED("passed"),
    FAILED("failed"),
    SKIPPED("skipped"),
    PENDING("pending"),
    UNDEFINED("undefined"),
    AMBIGUOUS("ambiguous");

    public static final List<Status> BASIC_STATES;
    private final String status;

    private Status(String statusString) {
        this.status = statusString;
    }

    public static Status fromString(String status) {
        return Status.valueOf(status.toUpperCase());
    }

    public Status basicStatus() {
        switch (this) {
            case PASSED: {
                return PASSED;
            }
            case FAILED: {
                return FAILED;
            }
        }
        return SKIPPED;
    }

    public static Status getHighestBasicState(Set<Status> allStates) {
        return BASIC_STATES.stream().filter(basicState -> allStates.stream().anyMatch(allState -> allState.basicStatus() == basicState)).findFirst().orElse(FAILED);
    }

    public String getStatusString() {
        return this.status;
    }

    static {
        BASIC_STATES = Arrays.asList(FAILED, SKIPPED, PASSED);
    }
}

