/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.filesystem;

import com.trivago.cluecumber.engine.exceptions.filesystem.FileCreationException;
import com.trivago.cluecumber.engine.exceptions.filesystem.MissingFileException;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileIO {
    @Inject
    public FileIO() {
    }

    public void writeContentToFile(String content, String filePath) throws FileCreationException {
        try (PrintStream ps = new PrintStream(filePath);){
            ps.println(content);
        }
        catch (IOException e) {
            throw new FileCreationException(filePath);
        }
    }

    public void writeContentToFile(byte[] content, String filePath) throws FileCreationException {
        Path path = Paths.get(filePath, new String[0]);
        try {
            Files.write(path, content, new OpenOption[0]);
        }
        catch (Exception e) {
            throw new FileCreationException(path.toString());
        }
    }

    public String readContentFromFile(String filePath) throws MissingFileException {
        try {
            byte[] bytes = Files.readAllBytes(Paths.get(filePath, new String[0]));
            return new String(bytes).trim();
        }
        catch (IOException e) {
            throw new MissingFileException(filePath);
        }
    }

    public boolean isExistingFile(String filePath) {
        File file = new File(filePath);
        return file.exists() && file.isFile();
    }
}

