/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.pojo;

import com.google.gson.annotations.SerializedName;
import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.json.pojo.ResultMatch;
import com.trivago.cluecumber.engine.json.pojo.Step;
import com.trivago.cluecumber.engine.json.pojo.Tag;
import com.trivago.cluecumber.engine.rendering.pages.renderering.RenderingUtils;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class Element {
    private List<ResultMatch> before = new ArrayList<ResultMatch>();
    private int line;
    private boolean isLastOfMultipleScenarioRuns = false;
    private boolean isNotLastOfMultipleScenarioRuns = false;
    private String featureName = "";
    private String featureUri = "";
    private String name = "";
    private String description = "";
    private String id = "";
    private List<ResultMatch> after = new ArrayList<ResultMatch>();
    private String type = "";
    private String keyword = "";
    private List<Step> backgroundSteps = new ArrayList<Step>();
    private List<Step> steps = new ArrayList<Step>();
    private List<Tag> tags = new ArrayList<Tag>();
    @SerializedName(value="start_timestamp")
    private String startTimestamp = "";
    private List<Element> childrenElements = new ArrayList<Element>();
    private transient int featureIndex = 0;
    private transient int scenarioIndex = 0;
    private transient boolean failOnPendingOrUndefined = false;

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public String getStartTimestamp() {
        return this.startTimestamp;
    }

    public void setStartTimestamp(String startTimestamp) {
        this.startTimestamp = startTimestamp;
    }

    public ZonedDateTime getStartDateTime() {
        return RenderingUtils.convertTimestampToZonedDateTime(this.startTimestamp);
    }

    public ZonedDateTime getEndDateTime() {
        ZonedDateTime startDateTime = this.getStartDateTime();
        if (startDateTime != null) {
            return this.getStartDateTime().plusNanos(this.getTotalDuration());
        }
        return null;
    }

    public String getStartDateString() {
        return RenderingUtils.convertZonedDateTimeToDateString(this.getStartDateTime());
    }

    public String getStartTimeString() {
        return RenderingUtils.convertZonedDateTimeToTimeString(this.getStartDateTime());
    }

    public String getEndDateString() {
        return RenderingUtils.convertZonedDateTimeToDateString(this.getEndDateTime());
    }

    public String getEndTimeString() {
        return RenderingUtils.convertZonedDateTimeToTimeString(this.getEndDateTime());
    }

    public List<ResultMatch> getBefore() {
        return this.before;
    }

    public void setBefore(List<ResultMatch> before) {
        this.before = before;
    }

    public boolean anyBeforeHookHasContent() {
        for (ResultMatch resultMatch : this.before) {
            if (!resultMatch.hasContent() && !resultMatch.isFailed()) continue;
            return true;
        }
        return false;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getName() {
        return !this.name.isEmpty() ? this.name : "[Unnamed]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<ResultMatch> getAfter() {
        return this.after;
    }

    public void setAfter(List<ResultMatch> after) {
        this.after = after;
    }

    public boolean anyAfterHookHasContent() {
        for (ResultMatch resultMatch : this.after) {
            if (!resultMatch.hasContent() && !resultMatch.isFailed()) continue;
            return true;
        }
        return false;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public List<Step> getBackgroundSteps() {
        return this.backgroundSteps;
    }

    public void setBackgroundSteps(List<Step> steps) {
        this.backgroundSteps = steps;
    }

    public boolean isScenario() {
        return this.type.equals("scenario");
    }

    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    public boolean isPassed() {
        return this.getStatus() == Status.PASSED;
    }

    public boolean isSkipped() {
        return this.getStatus() == Status.SKIPPED;
    }

    public Status getStatus() {
        Set<Status> allStates = this.before.stream().map(ResultMatch::getStatus).collect(Collectors.toSet());
        this.backgroundSteps.stream().map(ResultMatch::getStatus).forEach(allStates::add);
        this.steps.forEach(step -> step.getBefore().forEach(result -> allStates.add(result.getStatus())));
        this.steps.stream().map(ResultMatch::getStatus).forEach(allStates::add);
        this.steps.forEach(step -> step.getAfter().forEach(result -> allStates.add(result.getStatus())));
        this.after.stream().map(ResultMatch::getStatus).forEach(allStates::add);
        if (allStates.isEmpty()) {
            return Status.SKIPPED;
        }
        if (this.failOnPendingOrUndefined && allStates.size() == 1 && allStates.iterator().next().basicStatus() == Status.SKIPPED) {
            return Status.FAILED;
        }
        return Status.getHighestBasicState(allStates);
    }

    public String getFirstExceptionClass() {
        String firstException = this.getFirstException();
        String exceptionClass = firstException.split("\n")[0].trim();
        if (exceptionClass.isEmpty()) {
            exceptionClass = "";
        }
        return exceptionClass;
    }

    public String getFirstException() {
        String exception = this.getResultListException(this.before);
        if (exception != null && !exception.isEmpty()) {
            return exception;
        }
        exception = this.getStepException(this.backgroundSteps);
        if (exception != null && !exception.isEmpty()) {
            return exception;
        }
        exception = this.getStepException(this.steps);
        if (exception != null && !exception.isEmpty()) {
            return RenderingUtils.escapeHTML(exception);
        }
        exception = this.getResultListException(this.after);
        if (exception != null && !exception.isEmpty()) {
            return exception;
        }
        return "";
    }

    private String getStepException(List<Step> steps) {
        for (Step step : steps) {
            String exception = this.getResultListException(step.getBefore());
            if (exception != null && !exception.isEmpty()) {
                return exception;
            }
            exception = step.getResult().getErrorMessage();
            if (exception != null && !exception.isEmpty()) {
                return exception;
            }
            exception = this.getResultListException(step.getAfter());
            if (exception == null || exception.isEmpty()) continue;
            return exception;
        }
        return null;
    }

    private String getResultListException(List<ResultMatch> resultMatches) {
        for (ResultMatch match : resultMatches) {
            if (!match.isFailed()) continue;
            return RenderingUtils.escapeHTML(match.getResult().getErrorMessage());
        }
        return null;
    }

    public int getScenarioIndex() {
        return this.scenarioIndex;
    }

    public void setScenarioIndex(int scenarioIndex) {
        this.scenarioIndex = scenarioIndex;
    }

    public int getTotalNumberOfSteps() {
        return this.getAllStepsIncludingBackgroundSteps().size();
    }

    public int getTotalNumberOfPassedSteps() {
        return this.getNumberOfStepsWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedSteps() {
        return this.getNumberOfStepsWithStatus(Status.FAILED);
    }

    public int getTotalNumberOfSkippedSteps() {
        return this.getNumberOfStepsWithStatus(Status.SKIPPED);
    }

    private int getNumberOfStepsWithStatus(Status status) {
        return (int)this.getAllStepsIncludingBackgroundSteps().stream().filter(step -> step.getConsolidatedStatus() == status).count();
    }

    public long getTotalDuration() {
        long totalDurationNanoseconds = this.before.stream().mapToLong(beforeStep -> beforeStep.getResult().getDuration()).sum();
        totalDurationNanoseconds += this.backgroundSteps.stream().mapToLong(Step::getTotalDuration).sum();
        totalDurationNanoseconds += this.steps.stream().mapToLong(Step::getTotalDuration).sum();
        return totalDurationNanoseconds += this.after.stream().mapToLong(afterStep -> afterStep.getResult().getDuration()).sum();
    }

    public String returnTotalDurationString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getTotalDuration());
    }

    public boolean hasHooks() {
        return !this.getBefore().isEmpty() || !this.getAfter().isEmpty();
    }

    public boolean hasHooksWithContent() {
        return this.anyBeforeHookHasContent() || this.anyAfterHookHasContent();
    }

    public boolean hasDocStrings() {
        for (Step step : this.backgroundSteps) {
            if (step.getDocString() == null) continue;
            return true;
        }
        for (Step step : this.steps) {
            if (step.getDocString() == null) continue;
            return true;
        }
        return false;
    }

    public boolean hasStepHooks() {
        for (Step step : this.backgroundSteps) {
            if (!step.getBefore().isEmpty()) {
                return true;
            }
            if (step.getAfter().isEmpty()) continue;
            return true;
        }
        for (Step step : this.steps) {
            if (!step.getBefore().isEmpty()) {
                return true;
            }
            if (step.getAfter().isEmpty()) continue;
            return true;
        }
        return false;
    }

    public boolean hasStepHooksWithContent() {
        for (Step step : this.backgroundSteps) {
            if (!step.hasHooksWithContent()) continue;
            return true;
        }
        for (Step step : this.steps) {
            if (!step.hasHooksWithContent()) continue;
            return true;
        }
        return false;
    }

    public List<ResultMatch> getAllResultMatches() {
        ArrayList<ResultMatch> resultMatches = new ArrayList<ResultMatch>(this.getBefore());
        resultMatches.addAll(this.getAllStepsIncludingBackgroundSteps());
        resultMatches.addAll(this.getAfter());
        return resultMatches;
    }

    public String getFeatureName() {
        return this.featureName;
    }

    public void setFeatureName(String featureName) {
        this.featureName = featureName;
    }

    public int getFeatureIndex() {
        return this.featureIndex;
    }

    public void setFeatureIndex(int featureIndex) {
        this.featureIndex = featureIndex;
    }

    public void setFailOnPendingOrUndefined(boolean failOnPendingOrUndefined) {
        this.failOnPendingOrUndefined = failOnPendingOrUndefined;
    }

    public String getFeatureUri() {
        return this.featureUri;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public boolean getIsLastOfMultipleScenarioRuns() {
        return this.isLastOfMultipleScenarioRuns;
    }

    public void setIsLastOfMultipleScenarioRuns(boolean isLastOfMultipleScenarioRuns) {
        this.isLastOfMultipleScenarioRuns = isLastOfMultipleScenarioRuns;
    }

    public boolean getIsNotLastOfMultipleScenarioRuns() {
        return this.isNotLastOfMultipleScenarioRuns;
    }

    public void setIsNotLastOfMultipleScenarioRuns(boolean isNotLastOfMultipleScenarioRuns) {
        this.isNotLastOfMultipleScenarioRuns = isNotLastOfMultipleScenarioRuns;
    }

    public List<Element> getChildrenElements() {
        return this.childrenElements;
    }

    public void setChildrenElements(List<Element> childrenElements) {
        this.childrenElements = childrenElements;
    }

    public void setFeatureUri(String featureUri) {
        this.featureUri = featureUri;
    }

    public List<Step> getAllStepsIncludingBackgroundSteps() {
        ArrayList<Step> combinedSteps = new ArrayList<Step>(this.backgroundSteps);
        combinedSteps.addAll(this.steps);
        return combinedSteps;
    }
}

