/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.processors;

import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ElementMultipleRunsPreProcessor {
    @Inject
    public ElementMultipleRunsPreProcessor() {
    }

    public void addMultipleRunsInformationToScenarios(List<Report> reports) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Report report : reports) {
            elements.addAll(report.getElements());
        }
        Map<String, Map<Integer, List<Element>>> groupedElements = elements.stream().collect(Collectors.groupingBy(Element::getId, Collectors.groupingBy(Element::getLine)));
        groupedElements.values().forEach(idGroup -> idGroup.values().forEach(lineGroup -> {
            if (lineGroup.size() < 2) {
                return;
            }
            lineGroup.sort(Comparator.comparing(Element::getStartDateTime, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
            Element lastRunElement = (Element)lineGroup.get(0);
            lastRunElement.setIsLastOfMultipleScenarioRuns(true);
            ArrayList<Element> childrenElements = new ArrayList<Element>(lineGroup.subList(1, lineGroup.size()));
            for (Element element : childrenElements) {
                element.setIsNotLastOfMultipleScenarioRuns(true);
            }
            lastRunElement.setChildrenElements(childrenElements);
        }));
    }
}

