/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.renderering;

import com.trivago.cluecumber.engine.CluecumberEngine;
import java.net.URL;
import java.time.Duration;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.IntStream;

public class RenderingUtils {
    private static final int MICROSECOND_FACTOR = 1000000;
    private static final Pattern URL_PATTERN = Pattern.compile("(file.*)|((ftp|http|https)://(\\w+:?\\w*@)?(\\S+)(:[0-9]+)?(/|/([\\w#!:.?+=&%@\\-/]))?)");

    public static String convertNanosecondsToTimeString(long nanoseconds) {
        Duration durationMilliseconds = Duration.ofMillis(nanoseconds / 1000000L);
        long minutes = durationMilliseconds.toMinutes();
        long seconds = durationMilliseconds.minusMinutes(minutes).getSeconds();
        long milliseconds = durationMilliseconds.minusMinutes(minutes).minusSeconds(seconds).toMillis();
        return String.format("%dm %02ds %03dms", minutes, seconds, milliseconds);
    }

    public static long convertNanosecondsToMilliseconds(long nanoseconds) {
        return nanoseconds / 1000000L;
    }

    public static String getPluginVersion() {
        return CluecumberEngine.class.getPackage().getImplementationVersion();
    }

    public static String escapeHTML(String sourceString) {
        StringBuilder stringBuilder = new StringBuilder(Math.max(16, sourceString.length()));
        IntStream.range(0, sourceString.length()).forEachOrdered(i -> {
            char character = sourceString.charAt(i);
            if (character > '\u007f' || character == '\"' || character == '<' || character == '>' || character == '&') {
                stringBuilder.append("&#");
                stringBuilder.append((int)character);
                stringBuilder.append(';');
            } else {
                stringBuilder.append(character);
            }
        });
        return stringBuilder.toString();
    }

    public static String turnUrlsIntoLinks(String sourceString) {
        Matcher matcher = URL_PATTERN.matcher(sourceString);
        String targetString = sourceString;
        while (matcher.find()) {
            String found = matcher.group();
            targetString = targetString.replaceFirst(Pattern.quote(found), Matcher.quoteReplacement("<a href='" + found + "' target='_blank'>" + found + "</a>"));
        }
        return targetString;
    }

    public static ZonedDateTime convertTimestampToZonedDateTime(String timestampString) {
        try {
            return ZonedDateTime.parse(timestampString);
        }
        catch (Exception ignored) {
            return null;
        }
    }

    public static String convertZonedDateTimeToDateString(ZonedDateTime startDateTime) {
        try {
            return startDateTime.withZoneSameInstant(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static String convertZonedDateTimeToTimeString(ZonedDateTime startDateTime) {
        try {
            return startDateTime.withZoneSameInstant(ZoneId.systemDefault()).format(DateTimeFormatter.ofPattern("HH:mm:ss"));
        }
        catch (Exception exception) {
            return "";
        }
    }

    public static boolean isUrl(String value) {
        try {
            new URL(value);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static boolean isRelativeUrl(String value) {
        return value.startsWith("./") || value.startsWith("../") || value.startsWith("#");
    }
}

