/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.renderering;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllFeaturesPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.TreeViewPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.PageRenderer;
import freemarker.template.Template;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TreeViewPageRenderer
extends PageRenderer {
    private final PropertyManager propertyManager;

    @Inject
    public TreeViewPageRenderer(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(AllFeaturesPageCollection allFeaturesPageCollection, AllScenariosPageCollection allScenariosPageCollection, Template template) throws CluecumberException {
        LinkedHashMap<Feature, List<Element>> scenariosPerFeatures = new LinkedHashMap<Feature, List<Element>>();
        Set features = allFeaturesPageCollection.getFeatures().stream().sorted(Comparator.comparing(Feature::getName)).collect(Collectors.toCollection(LinkedHashSet::new));
        for (Feature feature : features) {
            scenariosPerFeatures.put(feature, allScenariosPageCollection.getElementsByFeatureIndex(feature.getIndex()));
        }
        return this.processedContent(template, new TreeViewPageCollection(scenariosPerFeatures, allFeaturesPageCollection.getPageTitle()), this.propertyManager.getNavigationLinks());
    }
}

