/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.templates;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TemplateConfiguration {
    private Configuration cfg;

    @Inject
    public TemplateConfiguration() {
    }

    public void init(String basePath) {
        this.cfg = new Configuration(Configuration.VERSION_2_3_31);
        this.cfg.setClassForTemplateLoading(this.getClass(), basePath);
        this.cfg.setDefaultEncoding("UTF-8");
        this.cfg.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        this.cfg.setWhitespaceStripping(true);
        this.cfg.setLogTemplateExceptions(false);
    }

    public Template getTemplate(String templateName) throws CluecumberException {
        Template template;
        try {
            template = this.cfg.getTemplate(templateName + ".ftl");
        }
        catch (Exception e) {
            throw new CluecumberException("Template '" + templateName + "' was not found or not parsable: " + e.getMessage());
        }
        return template;
    }
}

