/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.visitors;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.json.pojo.Step;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllStepsPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllStepsPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.engine.rendering.pages.visitors.PageVisitor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StepVisitor
implements PageVisitor {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final AllStepsPageRenderer allStepsPageRenderer;
    private final AllScenariosPageRenderer allScenariosPageRenderer;

    @Inject
    public StepVisitor(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, AllStepsPageRenderer allStepsPageRenderer, AllScenariosPageRenderer allScenariosPageRenderer) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.allStepsPageRenderer = allStepsPageRenderer;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
    }

    @Override
    public void visit(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberException {
        AllStepsPageCollection allStepsPageCollection = new AllStepsPageCollection(allScenariosPageCollection.getReports(), this.propertyManager.getCustomPageTitle());
        this.fileIO.writeContentToFile(this.allStepsPageRenderer.getRenderedContent(allStepsPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_STEPS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/step-summary.html");
        for (Step step : allStepsPageCollection.getSteps()) {
            this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContentByStepFilter(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_SCENARIOS), step), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/step-scenarios/step_" + step.getUrlFriendlyName() + ".html");
        }
    }
}

