/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.exceptions.filesystem.MissingFileException;
import com.trivago.cluecumber.engine.exceptions.properties.WrongOrMissingPropertyException;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.filesystem.FileSystemManager;
import com.trivago.cluecumber.engine.json.JsonPojoConverter;
import com.trivago.cluecumber.engine.json.pojo.Report;
import com.trivago.cluecumber.engine.json.processors.ElementIndexPreProcessor;
import com.trivago.cluecumber.engine.json.processors.ElementMultipleRunsPreProcessor;
import com.trivago.cluecumber.engine.logging.CluecumberLogger;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.ReportGenerator;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.RenderingUtils;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.List;
import javax.inject.Inject;

public final class CluecumberEngine {
    private final CluecumberLogger logger;
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;
    private final FileIO fileIO;
    private final JsonPojoConverter jsonPojoConverter;
    private final ElementIndexPreProcessor elementIndexPreProcessor;
    private final ElementMultipleRunsPreProcessor elementMultipleRunsPreProcessor;
    private final ReportGenerator reportGenerator;
    private boolean skip;

    @Inject
    public CluecumberEngine(CluecumberLogger logger, PropertyManager propertyManager, FileSystemManager fileSystemManager, FileIO fileIO, JsonPojoConverter jsonPojoConverter, ElementIndexPreProcessor elementIndexPreProcessor, ElementMultipleRunsPreProcessor elementMultipleRunsPreProcessor, ReportGenerator reportGenerator) {
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.fileIO = fileIO;
        this.jsonPojoConverter = jsonPojoConverter;
        this.logger = logger;
        this.elementIndexPreProcessor = elementIndexPreProcessor;
        this.elementMultipleRunsPreProcessor = elementMultipleRunsPreProcessor;
        this.reportGenerator = reportGenerator;
    }

    public void build(String sourceJsonReportDirectory, String generatedHtmlReportDirectory) throws CluecumberException {
        this.propertyManager.setSourceJsonReportDirectory(sourceJsonReportDirectory);
        this.propertyManager.setGeneratedHtmlReportDirectory(generatedHtmlReportDirectory);
        if (this.skip) {
            this.logger.info("Cluecumber report generation was skipped using the <skip> property.", CluecumberLogger.CluecumberLogLevel.DEFAULT);
            return;
        }
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info(String.format(" [ Cluecumber v%s ]", RenderingUtils.getPluginVersion()), CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT);
        this.propertyManager.logProperties();
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments");
        AllScenariosPageCollection allScenariosPageCollection = new AllScenariosPageCollection(this.propertyManager.getCustomPageTitle());
        List<Path> jsonFilePaths = this.fileSystemManager.getJsonFilePaths(this.propertyManager.getSourceJsonReportDirectory());
        for (Path jsonFilePath : jsonFilePaths) {
            String jsonString = this.fileIO.readContentFromFile(jsonFilePath.toString());
            try {
                Report[] reports = this.jsonPojoConverter.convertJsonToReportPojos(jsonString);
                allScenariosPageCollection.addReports(reports);
            }
            catch (CluecumberException e) {
                this.logger.warn("Could not parse JSON in file '" + jsonFilePath + "': " + e.getMessage());
            }
        }
        this.elementIndexPreProcessor.process(allScenariosPageCollection.getReports());
        if (this.propertyManager.isGroupPreviousScenarioRuns()) {
            this.elementMultipleRunsPreProcessor.addMultipleRunsInformationToScenarios(allScenariosPageCollection.getReports());
        }
        this.reportGenerator.generateReport(allScenariosPageCollection);
        this.logger.info("=> Cluecumber Report: file:///" + this.propertyManager.getGeneratedHtmlReportDirectory() + "/index.html", CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT, CluecumberLogger.CluecumberLogLevel.MINIMAL);
    }

    public void setCustomParameters(LinkedHashMap<String, String> customParameters) {
        if (customParameters == null) {
            return;
        }
        this.propertyManager.setCustomParameters(customParameters);
    }

    public void setCustomParametersFile(String customParametersFile) throws CluecumberException {
        this.propertyManager.setCustomParametersFile(customParametersFile);
    }

    public void setCustomParametersDisplayMode(String customParametersDisplayMode) {
        if (customParametersDisplayMode == null) {
            return;
        }
        this.propertyManager.setCustomParametersDisplayMode(customParametersDisplayMode);
    }

    public void setCustomNavigationLinks(LinkedHashMap<String, String> customNavigationLinks) {
        this.propertyManager.setCustomNavigationLinks(customNavigationLinks);
    }

    public void setFailScenariosOnPendingOrUndefinedSteps(boolean failScenariosOnPendingOrUndefinedSteps) {
        this.propertyManager.setFailScenariosOnPendingOrUndefinedSteps(failScenariosOnPendingOrUndefinedSteps);
    }

    public void setExpandSubSections(boolean expandSubSections) {
        this.propertyManager.setExpandSubSections(expandSubSections);
    }

    public void setExpandBeforeAfterHooks(boolean expandBeforeAfterHooks) {
        this.propertyManager.setExpandBeforeAfterHooks(expandBeforeAfterHooks);
    }

    public void setExpandStepHooks(boolean expandStepHooks) {
        this.propertyManager.setExpandStepHooks(expandStepHooks);
    }

    public void setExpandDocStrings(boolean expandDocStrings) {
        this.propertyManager.setExpandDocStrings(expandDocStrings);
    }

    public void setExpandAttachments(boolean expandAttachments) {
        this.propertyManager.setExpandAttachments(expandAttachments);
    }

    public void setExpandOutputs(boolean expandOutputs) {
        this.propertyManager.setExpandOutputs(expandOutputs);
    }

    public void setGroupPreviousScenarioRuns(boolean groupPreviousScenarioRuns) {
        this.propertyManager.setGroupPreviousScenarioRuns(groupPreviousScenarioRuns);
    }

    public void setExpandPreviousScenarioRuns(boolean expandPreviousScenarioRuns) {
        this.propertyManager.setExpandPreviousScenarioRuns(expandPreviousScenarioRuns);
    }

    public void setCustomCssFile(String customCss) throws MissingFileException {
        if (customCss == null) {
            return;
        }
        this.propertyManager.setCustomCssFile(customCss);
    }

    public void setCustomFavicon(String customFavicon) throws MissingFileException {
        if (customFavicon == null) {
            return;
        }
        this.propertyManager.setCustomFaviconFile(customFavicon);
    }

    public void setCustomStatusColorPassed(String customStatusColorPassed) throws WrongOrMissingPropertyException {
        this.propertyManager.setCustomStatusColorPassed(customStatusColorPassed);
    }

    public void setCustomStatusColorFailed(String customStatusColorFailed) throws WrongOrMissingPropertyException {
        this.propertyManager.setCustomStatusColorFailed(customStatusColorFailed);
    }

    public void setCustomStatusColorSkipped(String customStatusColorSkipped) throws WrongOrMissingPropertyException {
        this.propertyManager.setCustomStatusColorSkipped(customStatusColorSkipped);
    }

    public void setCustomPageTitle(String customPageTitle) {
        this.propertyManager.setCustomPageTitle(customPageTitle);
    }

    public void setStartPage(String startPage) {
        if (startPage == null) {
            return;
        }
        this.propertyManager.setStartPage(startPage);
    }

    public void setLogLevel(String logLevel) {
        this.logger.setLogLevel(logLevel);
    }
}

