/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.pojo;

import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.json.pojo.Argument;
import com.trivago.cluecumber.engine.json.pojo.Embedding;
import com.trivago.cluecumber.engine.json.pojo.Match;
import com.trivago.cluecumber.engine.json.pojo.Result;
import java.util.ArrayList;
import java.util.List;

public class ResultMatch {
    private Result result;
    private Match match;
    private List<String> output = new ArrayList<String>();
    private List<Embedding> embeddings = new ArrayList<Embedding>();

    public Result getResult() {
        return this.result != null ? this.result : new Result();
    }

    public void setResult(Result result) {
        this.result = result;
    }

    public Match getMatch() {
        return this.match != null ? this.match : new Match();
    }

    public void setMatch(Match match) {
        this.match = match;
    }

    public List<Embedding> getEmbeddings() {
        return this.embeddings;
    }

    public void setEmbeddings(List<Embedding> embeddings) {
        this.embeddings = embeddings;
    }

    public boolean hasEmbeddings() {
        return !this.embeddings.isEmpty();
    }

    public List<String> getOutput() {
        return this.output;
    }

    public void setOutput(List<String> output) {
        this.output = output;
    }

    public boolean hasOutputs() {
        return !this.output.isEmpty();
    }

    public String getGlueMethodName() {
        return this.getMatch().getLocation();
    }

    public List<Argument> getArguments() {
        return this.getMatch().getArguments();
    }

    public Status getStatus() {
        return Status.fromString(this.getResult().getStatus());
    }

    public String getStatusString() {
        return this.getStatus().getStatusString();
    }

    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    public boolean isPassed() {
        return this.getStatus() == Status.PASSED;
    }

    public boolean isSkipped() {
        return this.getConsolidatedStatus() == Status.SKIPPED;
    }

    public boolean hasContent() {
        return this.hasOutputs() || this.hasEmbeddings();
    }

    public Status getConsolidatedStatus() {
        return this.getStatus().basicStatus();
    }

    public String getConsolidatedStatusString() {
        return this.getConsolidatedStatus().getStatusString();
    }
}

