/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.pojo;

import com.google.gson.annotations.SerializedName;
import com.trivago.cluecumber.engine.json.pojo.Argument;
import com.trivago.cluecumber.engine.json.pojo.DocString;
import com.trivago.cluecumber.engine.json.pojo.ResultMatch;
import com.trivago.cluecumber.engine.json.pojo.Row;
import com.trivago.cluecumber.engine.rendering.pages.renderering.RenderingUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Step
extends ResultMatch {
    private List<ResultMatch> before = new ArrayList<ResultMatch>();
    private int line;
    private String name = "";
    private String keyword = "";
    private List<Row> rows = new ArrayList<Row>();
    private List<ResultMatch> after = new ArrayList<ResultMatch>();
    @SerializedName(value="doc_string")
    private DocString docString;
    private int collapseLevel = 0;
    private int index = 0;
    private boolean hasSubSections = false;
    private static final Map<String, String> stepMatchToNameWithArgumentPlaceholders = new HashMap<String, String>();

    public boolean hasHooksWithContent() {
        for (ResultMatch resultMatch : this.before) {
            if (!resultMatch.hasContent()) continue;
            return true;
        }
        for (ResultMatch resultMatch : this.after) {
            if (!resultMatch.hasContent()) continue;
            return true;
        }
        return false;
    }

    public boolean hasHooks() {
        return !this.before.isEmpty() || !this.after.isEmpty();
    }

    public List<ResultMatch> getBefore() {
        return this.before;
    }

    public void setBefore(List<ResultMatch> before) {
        this.before = before;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getName() {
        return !this.name.isEmpty() ? this.name : "[Unnamed]";
    }

    public void setName(String name) {
        this.name = name;
    }

    public String returnNameWithArguments() {
        String tmpName = this.getName();
        List<Argument> arguments = this.getArguments();
        for (int i = arguments.size() - 1; i >= 0; --i) {
            String argument = arguments.get(i).getVal();
            if (argument == null) continue;
            tmpName = tmpName.replaceFirst(Pattern.quote(argument), Matcher.quoteReplacement("<span class=\"parameter\">" + argument + "</span>"));
        }
        return tmpName;
    }

    public String returnNameWithArgumentPlaceholders() {
        return stepMatchToNameWithArgumentPlaceholders.computeIfAbsent(this.getMatch().getLocation(), matchName -> {
            String tmpName = this.getName();
            List<Argument> arguments = this.getArguments();
            for (int i = arguments.size() - 1; i >= 0; --i) {
                String argument = arguments.get(i).getVal();
                if (argument == null) continue;
                tmpName = tmpName.replaceFirst(Pattern.quote(argument), Matcher.quoteReplacement("{}"));
            }
            return tmpName;
        });
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Row> getRows() {
        return this.rows;
    }

    public void setRows(List<Row> rows) {
        this.rows = rows;
    }

    public List<ResultMatch> getAfter() {
        return this.after;
    }

    public void setAfter(List<ResultMatch> after) {
        this.after = after;
    }

    public DocString getDocString() {
        return this.docString;
    }

    public void setDocString(DocString docString) {
        this.docString = docString;
    }

    public long getTotalDuration() {
        long totalDurationNanoseconds = this.before.stream().mapToLong(beforeStep -> beforeStep.getResult().getDuration()).sum();
        totalDurationNanoseconds += this.getResult().getDuration();
        return totalDurationNanoseconds += this.after.stream().mapToLong(afterStep -> afterStep.getResult().getDuration()).sum();
    }

    public String returnTotalDurationString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getTotalDuration());
    }

    public String getUrlFriendlyName() {
        return Integer.toString(this.hashCode()).replace("-", "0");
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Step step = (Step)o;
        return Objects.equals(this.getUniqueName(), step.getUniqueName());
    }

    public int hashCode() {
        return Objects.hash(this.getUniqueName());
    }

    public int getCollapseLevel() {
        return this.collapseLevel;
    }

    public void setCollapseLevel(int collapseLevel) {
        this.collapseLevel = collapseLevel;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean hasSubSections() {
        return this.hasSubSections;
    }

    public void setHasSubSections(boolean hasSubSections) {
        this.hasSubSections = hasSubSections;
    }

    public String getUniqueName() {
        return this.getGlueMethodName() + "_" + this.returnNameWithArgumentPlaceholders();
    }
}

