/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.processors;

import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import com.trivago.cluecumber.engine.json.pojo.Step;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ElementIndexPreProcessor {
    @Inject
    public ElementIndexPreProcessor() {
    }

    public void process(List<Report> reports) {
        ArrayList<Element> elements = new ArrayList<Element>();
        for (Report report : reports) {
            elements.addAll(report.getElements());
        }
        List sortedElements = elements.stream().sorted(Comparator.comparing(Element::getStartTimestamp)).collect(Collectors.toList());
        int scenarioIndex = 0;
        for (Element element : sortedElements) {
            if (!element.isScenario()) continue;
            element.setScenarioIndex(++scenarioIndex);
            int stepIndex = 0;
            Step oldStep = null;
            for (Step step : element.getBackgroundSteps()) {
                this.processStep(step, stepIndex, oldStep);
                oldStep = step;
                ++stepIndex;
            }
            oldStep = null;
            for (Step step : element.getSteps()) {
                this.processStep(step, stepIndex, oldStep);
                oldStep = step;
                ++stepIndex;
            }
        }
    }

    private void processStep(Step step, int stepIndex, Step oldStep) {
        int count = 0;
        step.setIndex(stepIndex);
        for (int i = 0; i < step.getKeyword().length() && step.getKeyword().charAt(i) == '>'; ++i) {
            ++count;
        }
        if (count > 0) {
            step.setCollapseLevel(count);
            step.setKeyword(step.getKeyword().substring(count).trim());
        }
        if (oldStep != null && oldStep.getCollapseLevel() < step.getCollapseLevel()) {
            oldStep.setHasSubSections(true);
        }
    }
}

