/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.json.processors;

import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import com.trivago.cluecumber.engine.json.pojo.Step;
import com.trivago.cluecumber.engine.json.pojo.Tag;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ElementMultipleRunsPreProcessor {
    @Inject
    public ElementMultipleRunsPreProcessor() {
    }

    public void addMultipleRunsInformationToScenarios(List<Report> reports) {
        HashMap<String, List> elementsByUniqueId = new HashMap<String, List>();
        for (Report report : reports) {
            for (Element element2 : report.getElements()) {
                String combinedId = this.generateCombinedId(element2);
                elementsByUniqueId.computeIfAbsent(combinedId, k -> new ArrayList()).add(element2);
            }
        }
        for (List group : elementsByUniqueId.values()) {
            if (group.size() < 2) continue;
            group.sort(Comparator.comparing(Element::getStartDateTime, Comparator.nullsLast(Comparator.naturalOrder())).reversed());
            Element parentElement = (Element)group.remove(0);
            parentElement.setMultiRunParent(true);
            group.forEach(element -> element.isMultiRunChild(true));
            parentElement.setMultiRunChildren(group);
        }
        for (Report report : reports) {
            report.getElements().removeIf(Element::isMultiRunChild);
        }
    }

    private String generateCombinedId(Element element) {
        ArrayList argumentValues = new ArrayList();
        ArrayList<CallSite> docStrings = new ArrayList<CallSite>();
        ArrayList<List<String>> outputs = new ArrayList<List<String>>();
        ArrayList rows = new ArrayList();
        for (Step step : element.getSteps()) {
            step.getMatch().getArguments().stream().map(argument -> argument.getOffset() + ": " + argument.getVal()).forEach(argumentValues::add);
            if (step.getDocString() != null) {
                docStrings.add((CallSite)((Object)(step.getDocString().getLine() + ": " + step.getDocString().getValue())));
            }
            if (step.getOutput() != null) {
                outputs.add(step.getOutput());
            }
            if (step.getRows() == null) continue;
            step.getRows().forEach(row -> rows.add(String.join((CharSequence)", ", row.getCells())));
        }
        return String.valueOf((element.getFeatureIndex() + element.getDescription() + element.getLine() + element.getFeatureName() + element.getName() + element.getId() + element.getTags().stream().map(Tag::getName).collect(Collectors.joining(",")) + element.getTotalNumberOfSteps() + element.getSteps().stream().map(Step::getKeyword).collect(Collectors.joining(", ")) + element.getSteps().stream().map(Step::getName).collect(Collectors.joining(", ")) + String.join((CharSequence)", ", docStrings) + String.join((CharSequence)", ", argumentValues) + String.join((CharSequence)", ", rows) + outputs.stream().map(output -> String.join((CharSequence)", ", output)).collect(Collectors.joining(", "))).hashCode());
    }
}

