/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.properties;

import com.trivago.cluecumber.engine.constants.Navigation;
import com.trivago.cluecumber.engine.constants.Settings;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.exceptions.filesystem.MissingFileException;
import com.trivago.cluecumber.engine.exceptions.properties.WrongOrMissingPropertyException;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.logging.CluecumberLogger;
import com.trivago.cluecumber.engine.properties.PropertiesFileLoader;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.Link;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.LinkType;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private static final String COLOR_PATTERN = "^#([A-Fa-f0-9]{6}|[A-Fa-f0-9]{3})$";
    private final CluecumberLogger logger;
    private final FileIO fileIO;
    private final PropertiesFileLoader propertiesFileLoader;
    private final Map<String, String> customParameters = new LinkedHashMap<String, String>();
    private final Map<String, String> customNavigationLinks = new LinkedHashMap<String, String>();
    private String sourceJsonReportDirectory;
    private String generatedHtmlReportDirectory;
    private boolean failScenariosOnPendingOrUndefinedSteps = false;
    private boolean expandSubSections = false;
    private boolean expandBeforeAfterHooks = false;
    private boolean expandStepHooks = false;
    private boolean expandDocStrings = false;
    private boolean expandAttachments = true;
    private boolean expandOutputs = false;
    private boolean groupPreviousScenarioRuns = false;
    private boolean expandPreviousScenarioRuns = false;
    private String customCssFile;
    private String customFaviconFile;
    private String customParametersFile;
    private Settings.CustomParamDisplayMode customParametersDisplayMode = Settings.CustomParamDisplayMode.ALL_PAGES;
    private String customStatusColorPassed = "#60cc79";
    private String customStatusColorFailed = "#fc7180";
    private String customStatusColorSkipped = "#f7c42b";
    private String customPageTitle = "Cluecumber Report";
    private Settings.StartPage startPage = Settings.StartPage.ALL_SCENARIOS;

    @Inject
    public PropertyManager(CluecumberLogger logger, FileIO fileIO, PropertiesFileLoader propertiesFileLoader) {
        this.logger = logger;
        this.fileIO = fileIO;
        this.propertiesFileLoader = propertiesFileLoader;
    }

    public String getSourceJsonReportDirectory() {
        return this.sourceJsonReportDirectory;
    }

    public void setSourceJsonReportDirectory(String sourceJsonReportDirectory) throws WrongOrMissingPropertyException {
        if (!this.isSet(sourceJsonReportDirectory)) {
            throw new WrongOrMissingPropertyException("sourceJsonReportDirectory");
        }
        this.sourceJsonReportDirectory = sourceJsonReportDirectory;
    }

    public String getGeneratedHtmlReportDirectory() {
        return this.generatedHtmlReportDirectory;
    }

    public void setGeneratedHtmlReportDirectory(String generatedHtmlReportDirectory) throws WrongOrMissingPropertyException {
        if (!this.isSet(generatedHtmlReportDirectory)) {
            throw new WrongOrMissingPropertyException("generatedHtmlReportDirectory");
        }
        this.generatedHtmlReportDirectory = generatedHtmlReportDirectory;
    }

    public Map<String, String> getCustomParameters() {
        return this.customParameters;
    }

    public void setCustomParameters(Map<String, String> customParameters) {
        this.customParameters.putAll(customParameters);
    }

    public String getCustomParametersFile() {
        return this.customParametersFile;
    }

    public void setCustomParametersFile(String customParametersFile) throws CluecumberException {
        this.customParametersFile = customParametersFile;
        if (!this.isSet(customParametersFile)) {
            return;
        }
        if (!this.fileIO.isExistingFile(customParametersFile)) {
            throw new MissingFileException(customParametersFile + " (customParametersFile)");
        }
        LinkedHashMap<String, String> customParameters = this.propertiesFileLoader.loadPropertiesMap(customParametersFile);
        this.customParameters.putAll(customParameters);
    }

    public Settings.CustomParamDisplayMode getCustomParametersDisplayMode() {
        return this.customParametersDisplayMode;
    }

    public void setCustomParametersDisplayMode(String customParametersDisplayMode) {
        try {
            this.customParametersDisplayMode = Settings.CustomParamDisplayMode.valueOf(customParametersDisplayMode.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unknown setting for custom parameter page(s): '" + customParametersDisplayMode + "'. Must be one of " + Arrays.toString((Object[])Settings.CustomParamDisplayMode.values()));
            this.customParametersDisplayMode = Settings.CustomParamDisplayMode.SCENARIO_PAGES;
        }
    }

    public void setCustomNavigationLinks(Map<String, String> customNavigationLinks) {
        if (customNavigationLinks == null) {
            return;
        }
        this.customNavigationLinks.putAll(customNavigationLinks);
    }

    public List<Link> getNavigationLinks() {
        LinkedList<Link> links = new LinkedList<Link>(Navigation.internalLinks);
        this.customNavigationLinks.forEach((key, value) -> {
            String linkName = key.replace("_", " ");
            links.add(new Link(linkName, (String)value, LinkType.EXTERNAL));
        });
        links.removeIf(link -> !this.groupPreviousScenarioRuns && link.getName().equals("rerun_scenarios"));
        return links;
    }

    public boolean isFailScenariosOnPendingOrUndefinedSteps() {
        return this.failScenariosOnPendingOrUndefinedSteps;
    }

    public void setFailScenariosOnPendingOrUndefinedSteps(boolean failScenariosOnPendingOrUndefinedSteps) {
        this.failScenariosOnPendingOrUndefinedSteps = failScenariosOnPendingOrUndefinedSteps;
    }

    public boolean isExpandSubSections() {
        return this.expandSubSections;
    }

    public void setExpandSubSections(boolean expandSubSections) {
        this.expandSubSections = expandSubSections;
    }

    public boolean isExpandBeforeAfterHooks() {
        return this.expandBeforeAfterHooks;
    }

    public void setExpandBeforeAfterHooks(boolean expandBeforeAfterHooks) {
        this.expandBeforeAfterHooks = expandBeforeAfterHooks;
    }

    public boolean isExpandStepHooks() {
        return this.expandStepHooks;
    }

    public void setExpandStepHooks(boolean expandStepHooks) {
        this.expandStepHooks = expandStepHooks;
    }

    public boolean isExpandDocStrings() {
        return this.expandDocStrings;
    }

    public void setExpandDocStrings(boolean expandDocStrings) {
        this.expandDocStrings = expandDocStrings;
    }

    public boolean isExpandAttachments() {
        return this.expandAttachments;
    }

    public boolean isExpandOutputs() {
        return this.expandOutputs;
    }

    public void setExpandAttachments(boolean expandAttachments) {
        this.expandAttachments = expandAttachments;
    }

    public void setExpandOutputs(boolean expandOutputs) {
        this.expandOutputs = expandOutputs;
    }

    public boolean isGroupPreviousScenarioRuns() {
        return this.groupPreviousScenarioRuns;
    }

    public void setGroupPreviousScenarioRuns(boolean groupPreviousScenarioRuns) {
        this.groupPreviousScenarioRuns = groupPreviousScenarioRuns;
    }

    public boolean isExpandPreviousScenarioRuns() {
        return this.expandPreviousScenarioRuns;
    }

    public void setExpandPreviousScenarioRuns(boolean expandPreviousScenarioRuns) {
        this.expandPreviousScenarioRuns = expandPreviousScenarioRuns;
    }

    public String getCustomCssFile() {
        return this.customCssFile;
    }

    public void setCustomCssFile(String customCssFile) throws MissingFileException {
        this.customCssFile = customCssFile;
        if (!this.isSet(customCssFile)) {
            return;
        }
        if (!this.fileIO.isExistingFile(customCssFile)) {
            throw new MissingFileException(customCssFile + " (customCssFile)");
        }
    }

    public String getCustomFaviconFile() {
        return this.customFaviconFile;
    }

    public void setCustomFaviconFile(String customFaviconFile) throws MissingFileException {
        this.customFaviconFile = customFaviconFile;
        if (!this.isSet(customFaviconFile)) {
            return;
        }
        if (!this.fileIO.isExistingFile(customFaviconFile)) {
            throw new MissingFileException(customFaviconFile + " (customFaviconFile)");
        }
    }

    public String getCustomStatusColorPassed() {
        return this.customStatusColorPassed;
    }

    public void setCustomStatusColorPassed(String customStatusColorPassed) throws WrongOrMissingPropertyException {
        if (!this.isSet(customStatusColorPassed)) {
            return;
        }
        this.checkHexColorValidity(customStatusColorPassed, "customStatusColorPassed");
        this.customStatusColorPassed = customStatusColorPassed;
    }

    public String getCustomStatusColorFailed() {
        return this.customStatusColorFailed;
    }

    public void setCustomStatusColorFailed(String customStatusColorFailed) throws WrongOrMissingPropertyException {
        if (!this.isSet(customStatusColorFailed)) {
            return;
        }
        this.checkHexColorValidity(customStatusColorFailed, "customStatusColorFailed");
        this.customStatusColorFailed = customStatusColorFailed;
    }

    public String getCustomStatusColorSkipped() {
        return this.customStatusColorSkipped;
    }

    public void setCustomStatusColorSkipped(String customStatusColorSkipped) throws WrongOrMissingPropertyException {
        if (!this.isSet(customStatusColorSkipped)) {
            return;
        }
        this.checkHexColorValidity(customStatusColorSkipped, "customStatusColorSkipped");
        this.customStatusColorSkipped = customStatusColorSkipped;
    }

    public String getCustomPageTitle() {
        return this.customPageTitle;
    }

    public void setCustomPageTitle(String customPageTitle) {
        if (this.isSet(customPageTitle)) {
            this.customPageTitle = customPageTitle;
        }
    }

    public void logProperties() {
        this.logger.info("- source JSON report directory     : " + this.sourceJsonReportDirectory, CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT);
        this.logger.info("- generated HTML report directory  : " + this.generatedHtmlReportDirectory, CluecumberLogger.CluecumberLogLevel.DEFAULT, CluecumberLogger.CluecumberLogLevel.COMPACT);
        boolean customParametersFileExists = this.isSet(this.customParametersFile);
        if (customParametersFileExists) {
            this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
            this.logger.info("- custom parameters file           : " + this.customParametersFile, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        }
        if (!this.customParameters.isEmpty()) {
            if (!customParametersFileExists) {
                this.logger.logInfoSeparator(new CluecumberLogger.CluecumberLogLevel[0]);
            }
            this.customParameters.entrySet().stream().map(entry -> "- custom parameter                 : " + (String)entry.getKey() + " -> " + (String)entry.getValue()).forEach(logString -> this.logger.info((CharSequence)logString, CluecumberLogger.CluecumberLogLevel.DEFAULT));
        }
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- fail pending/undefined scenarios : " + this.failScenariosOnPendingOrUndefinedSteps, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand sub sections              : " + this.expandSubSections, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand before/after hooks        : " + this.expandBeforeAfterHooks, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand step hooks                : " + this.expandStepHooks, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand doc strings               : " + this.expandDocStrings, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand step outputs              : " + this.expandOutputs, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand attachments               : " + this.expandAttachments, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- page title                       : " + this.customPageTitle, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- start page                       : " + this.startPage, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- custom parameters display mode   : " + this.customParametersDisplayMode, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- group previous scenario runs     : " + this.groupPreviousScenarioRuns, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.info("- expand previous scenario runs    : " + this.expandPreviousScenarioRuns, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        if (!this.customNavigationLinks.isEmpty()) {
            this.customNavigationLinks.entrySet().stream().map(entry -> "- custom navigation link           : " + (String)entry.getKey() + " -> " + (String)entry.getValue()).forEach(logString -> this.logger.info((CharSequence)logString, CluecumberLogger.CluecumberLogLevel.DEFAULT));
        }
        if (this.isSet(this.customCssFile)) {
            this.logger.info("- custom CSS file                  : " + this.customCssFile, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        }
        if (this.isSet(this.customFaviconFile)) {
            this.logger.info("- custom favicon file              : " + this.customFaviconFile, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        }
        this.logger.info("- colors (passed, failed, skipped) : " + this.customStatusColorPassed + ", " + this.customStatusColorFailed + ", " + this.customStatusColorSkipped, CluecumberLogger.CluecumberLogLevel.DEFAULT);
        this.logger.logInfoSeparator(CluecumberLogger.CluecumberLogLevel.DEFAULT);
    }

    private boolean isSet(String string) {
        return string != null && !string.trim().isEmpty();
    }

    private void checkHexColorValidity(String color, String colorPropertyName) throws WrongOrMissingPropertyException {
        if (!Pattern.compile(COLOR_PATTERN).matcher(color).matches()) {
            throw new WrongOrMissingPropertyException(colorPropertyName);
        }
    }

    public Settings.StartPage getStartPage() {
        return this.startPage;
    }

    public void setStartPage(String startPage) {
        try {
            this.startPage = Settings.StartPage.valueOf(startPage.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            this.logger.warn("Unknown start page '" + startPage + "'. Must be one of " + Arrays.toString((Object[])Settings.StartPage.values()));
            this.startPage = Settings.StartPage.ALL_SCENARIOS;
        }
    }
}

