/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering;

import com.trivago.cluecumber.engine.constants.Settings;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.exceptions.filesystem.PathCreationException;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.filesystem.FileSystemManager;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.StartPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.CustomCssRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.StartPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.engine.rendering.pages.visitors.PageVisitor;
import com.trivago.cluecumber.engine.rendering.pages.visitors.VisitorDirectory;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportGenerator {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;
    private final StartPageRenderer startPageRenderer;
    private final CustomCssRenderer customCssRenderer;
    private final List<PageVisitor> visitors;

    @Inject
    ReportGenerator(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, FileSystemManager fileSystemManager, StartPageRenderer startPageRenderer, CustomCssRenderer customCssRenderer, VisitorDirectory visitorDirectory) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.startPageRenderer = startPageRenderer;
        this.customCssRenderer = customCssRenderer;
        this.visitors = visitorDirectory.getVisitors();
    }

    public void generateReport(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberException {
        String reportDirectory = this.propertyManager.getGeneratedHtmlReportDirectory();
        this.createDirectories(reportDirectory);
        this.copyStaticReportAssets(reportDirectory);
        this.copyCustomCss(reportDirectory);
        this.copyCustomFavicon(reportDirectory);
        boolean redirectToFirstScenarioPage = this.propertyManager.getStartPage() == Settings.StartPage.ALL_SCENARIOS && allScenariosPageCollection.getTotalNumberOfScenarios() == 1;
        this.generateStartPage(redirectToFirstScenarioPage);
        for (PageVisitor visitor : this.visitors) {
            allScenariosPageCollection.accept(visitor);
        }
    }

    private void generateStartPage(boolean redirectToFirstScenarioPage) throws CluecumberException {
        StartPageCollection startPageCollection = new StartPageCollection(this.propertyManager.getStartPage(), redirectToFirstScenarioPage);
        this.fileIO.writeContentToFile(this.startPageRenderer.getRenderedContent(this.templateEngine.getTemplate(TemplateEngine.Template.START_PAGE), startPageCollection, this.propertyManager.getNavigationLinks()), this.propertyManager.getGeneratedHtmlReportDirectory() + "/index.html");
    }

    private void createDirectories(String reportDirectory) throws PathCreationException {
        this.fileSystemManager.createDirectory(reportDirectory);
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages");
        String pagesDirectory = reportDirectory + "/pages/";
        this.fileSystemManager.createDirectory(pagesDirectory + "scenario-detail");
        this.fileSystemManager.createDirectory(pagesDirectory + "feature-scenarios");
        this.fileSystemManager.createDirectory(pagesDirectory + "tag-scenarios");
        this.fileSystemManager.createDirectory(pagesDirectory + "step-scenarios");
    }

    private void copyCustomCss(String reportDirectory) throws CluecumberException {
        String customCss = this.propertyManager.getCustomCssFile();
        if (customCss != null && !customCss.isEmpty()) {
            this.fileSystemManager.copyResource(customCss, reportDirectory + "/css/cluecumber-additional.css");
        } else {
            this.copyFileFromJarToReportDirectory("/css/cluecumber-additional.css");
        }
        this.fileIO.writeContentToFile(this.customCssRenderer.getRenderedCustomCssContent(this.templateEngine.getTemplate(TemplateEngine.Template.CUSTOM_CSS)), reportDirectory + "/css/cluecumber-custom.css");
    }

    private void copyCustomFavicon(String reportDirectory) throws CluecumberException {
        String customFavicon = this.propertyManager.getCustomFaviconFile();
        if (customFavicon != null && !customFavicon.isEmpty()) {
            this.fileSystemManager.copyResource(customFavicon, reportDirectory + "/img/favicon.png");
        } else {
            this.copyFileFromJarToReportDirectory("/img/favicon.png");
        }
    }

    private void copyStaticReportAssets(String reportDirectory) throws CluecumberException {
        this.fileSystemManager.createDirectory(reportDirectory + "/img");
        this.fileSystemManager.createDirectory(reportDirectory + "/css");
        this.copyFileFromJarToReportDirectory("/css/bootstrap.min.css");
        this.copyFileFromJarToReportDirectory("/css/cluecumber.css");
        this.copyFileFromJarToReportDirectory("/css/datatables.min.css");
        this.copyFileFromJarToReportDirectory("/css/jquery.fancybox.min.css");
        this.copyFileFromJarToReportDirectory("/css/dataTables.bootstrap4.min.css");
        this.fileSystemManager.createDirectory(reportDirectory + "/font");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.eot");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.svg");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.ttf");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.woff");
        this.copyFileFromJarToReportDirectory("/font/cluecumber.woff2");
        this.fileSystemManager.createDirectory(reportDirectory + "/js");
        this.copyFileFromJarToReportDirectory("/js/jquery.min.js");
        this.copyFileFromJarToReportDirectory("/js/bootstrap.min.js");
        this.copyFileFromJarToReportDirectory("/js/popper.min.js");
        this.copyFileFromJarToReportDirectory("/js/Chart.bundle.min.js");
        this.copyFileFromJarToReportDirectory("/js/datatables.min.js");
        this.copyFileFromJarToReportDirectory("/js/jquery.fancybox.min.js");
    }

    private void copyFileFromJarToReportDirectory(String fileName) throws CluecumberException {
        this.fileSystemManager.copyResourceFromJar("/template" + fileName, this.propertyManager.getGeneratedHtmlReportDirectory() + fileName);
    }
}

