/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections;

import com.trivago.cluecumber.engine.constants.Status;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import com.trivago.cluecumber.engine.json.pojo.Step;
import com.trivago.cluecumber.engine.json.pojo.Tag;
import com.trivago.cluecumber.engine.rendering.pages.pojos.Feature;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.PageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.RenderingUtils;
import com.trivago.cluecumber.engine.rendering.pages.visitors.PageVisitor;
import com.trivago.cluecumber.engine.rendering.pages.visitors.Visitable;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;

public class AllScenariosPageCollection
extends PageCollection
implements Visitable {
    private List<Report> reports = new ArrayList<Report>();
    private boolean groupPreviousScenarioRuns;
    private boolean expandPreviousScenarioRuns;
    private Tag tagFilter;
    private Feature featureFilter;
    private Step stepFilter;

    public AllScenariosPageCollection(String pageTitle) {
        super(pageTitle);
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public List<Element> getElementsByFeatureIndex(int featureIndex) {
        return this.getReports().stream().filter(report -> report.getFeatureIndex() == featureIndex).flatMap(report -> report.getElements().stream()).sorted(Comparator.comparing(Element::getName)).collect(Collectors.toList());
    }

    public void clearReports() {
        this.reports = new ArrayList<Report>();
    }

    public void addReports(Report[] reportList) {
        if (reportList == null) {
            return;
        }
        this.addReports(Arrays.asList(reportList));
    }

    private void addReports(List<Report> reportList) {
        this.reports.addAll(reportList);
    }

    public int getTotalNumberOfScenarios() {
        return this.reports.stream().map(Report::getElements).mapToInt(elements -> (int)elements.stream().filter(Element::isScenario).count()).sum();
    }

    public boolean hasFailedScenarios() {
        return this.getTotalNumberOfFailedScenarios() > 0;
    }

    public boolean hasFailedScenariosNotPassedOnLastRun() {
        return this.getTotalNumberOfFailedScenarioWithoutLaterRuns() > 0;
    }

    public boolean hasPassedScenarios() {
        return this.getTotalNumberOfPassedScenarios() > 0;
    }

    public boolean hasSkippedScenarios() {
        return this.getTotalNumberOfSkippedScenarios() > 0;
    }

    public boolean hasMultiRunChildren() {
        return this.getTotalNumberOfMultiRunChildren() > 0;
    }

    public int getTotalNumberOfPassedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.FAILED);
    }

    public int getTotalNumberOfFailedScenarioWithoutLaterRuns() {
        return this.reports.stream().mapToInt(report -> (int)report.getElements().stream().filter(element -> element.getStatus().equals((Object)Status.FAILED) && !element.isMultiRunChild()).count()).sum();
    }

    public int getTotalNumberOfSkippedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.SKIPPED);
    }

    public int getTotalNumberOfMultiRunChildren() {
        int sum = 0;
        for (Report report : this.reports) {
            for (Element element : report.getElements()) {
                sum += element.getMultiRunChildren().size();
            }
        }
        return sum;
    }

    private int getNumberOfScenariosWithStatus(Status status) {
        return this.reports.stream().mapToInt(report -> (int)report.getElements().stream().filter(element -> element.getStatus().equals((Object)status)).count()).sum();
    }

    long getTotalDuration() {
        return this.reports.stream().mapToLong(Report::getTotalDuration).sum();
    }

    public String getTotalDurationString() {
        ZonedDateTime earliestStartDateTime = this.getEarliestStartDateTime();
        ZonedDateTime latestEndDateTime = this.getLatestEndDateTime();
        if (earliestStartDateTime == null || latestEndDateTime == null) {
            return RenderingUtils.convertNanosecondsToTimeString(this.getTotalDuration());
        }
        return RenderingUtils.convertNanosecondsToTimeString(ChronoUnit.NANOS.between(earliestStartDateTime, latestEndDateTime));
    }

    private ZonedDateTime getEarliestStartDateTime() {
        ZonedDateTime earliestStartDateTime = null;
        for (Report report : this.reports) {
            for (Element element : report.getElements()) {
                ZonedDateTime currentStartDateTime = element.getStartDateTime();
                if (currentStartDateTime == null || earliestStartDateTime != null && !currentStartDateTime.isBefore(earliestStartDateTime)) continue;
                earliestStartDateTime = currentStartDateTime;
            }
        }
        return earliestStartDateTime;
    }

    private ZonedDateTime getLatestEndDateTime() {
        ZonedDateTime latestEndDateTime = null;
        for (Report report : this.reports) {
            for (Element element : report.getElements()) {
                ZonedDateTime currentEndDateTime = element.getEndDateTime();
                if (currentEndDateTime == null || latestEndDateTime != null && !currentEndDateTime.isAfter(latestEndDateTime)) continue;
                latestEndDateTime = currentEndDateTime;
            }
        }
        return latestEndDateTime;
    }

    public String returnStartDateTimeString() {
        ZonedDateTime earliestStartDateTime = this.getEarliestStartDateTime();
        if (earliestStartDateTime != null) {
            return RenderingUtils.convertZonedDateTimeToDateString(earliestStartDateTime) + " " + RenderingUtils.convertZonedDateTimeToTimeString(earliestStartDateTime);
        }
        return "";
    }

    public String returnEndDateTimeString() {
        ZonedDateTime latestEndDateTime = this.getLatestEndDateTime();
        if (latestEndDateTime != null) {
            return RenderingUtils.convertZonedDateTimeToDateString(latestEndDateTime) + " " + RenderingUtils.convertZonedDateTimeToTimeString(latestEndDateTime);
        }
        return "";
    }

    public Tag getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(Tag tagFilter) {
        this.tagFilter = tagFilter;
    }

    public Feature getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(Feature featureFilter) {
        this.featureFilter = featureFilter;
    }

    public Step getStepFilter() {
        return this.stepFilter;
    }

    public void setStepFilter(Step stepFilter) {
        this.stepFilter = stepFilter;
    }

    @Override
    public boolean isGroupPreviousScenarioRuns() {
        return this.groupPreviousScenarioRuns;
    }

    @Override
    public void setGroupPreviousScenarioRuns(boolean groupPreviousScenarioRuns) {
        this.groupPreviousScenarioRuns = groupPreviousScenarioRuns;
    }

    @Override
    public boolean isExpandPreviousScenarioRuns() {
        return this.expandPreviousScenarioRuns;
    }

    @Override
    public void setExpandPreviousScenarioRuns(boolean expandPreviousScenarioRuns) {
        this.expandPreviousScenarioRuns = expandPreviousScenarioRuns;
    }

    @Override
    public AllScenariosPageCollection clone() throws CloneNotSupportedException {
        AllScenariosPageCollection clone = (AllScenariosPageCollection)super.clone();
        clone.setFeatureFilter(null);
        clone.setStepFilter(null);
        clone.setTagFilter(null);
        clone.clearReports();
        ArrayList<Report> clonedReports = new ArrayList<Report>();
        for (Report r : this.getReports()) {
            clonedReports.add((Report)r.clone());
        }
        clone.addReports(clonedReports);
        return clone;
    }

    @Override
    public void accept(PageVisitor visitor) throws CluecumberException {
        visitor.visit(this);
    }
}

