/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.engine.rendering.pages.visitors;

import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.filesystem.FileIO;
import com.trivago.cluecumber.engine.json.pojo.Element;
import com.trivago.cluecumber.engine.json.pojo.Report;
import com.trivago.cluecumber.engine.properties.PropertyManager;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.AllScenariosPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.pojos.pagecollections.ScenarioDetailsPageCollection;
import com.trivago.cluecumber.engine.rendering.pages.renderering.AllScenariosPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.renderering.ScenarioDetailsPageRenderer;
import com.trivago.cluecumber.engine.rendering.pages.templates.TemplateEngine;
import com.trivago.cluecumber.engine.rendering.pages.visitors.PageVisitor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScenarioVisitor
implements PageVisitor {
    private final FileIO fileIO;
    private final TemplateEngine templateEngine;
    private final PropertyManager propertyManager;
    private final AllScenariosPageRenderer allScenariosPageRenderer;
    private final ScenarioDetailsPageRenderer scenarioDetailsPageRenderer;

    @Inject
    public ScenarioVisitor(FileIO fileIO, TemplateEngine templateEngine, PropertyManager propertyManager, AllScenariosPageRenderer allScenariosPageRenderer, ScenarioDetailsPageRenderer scenarioDetailsPageRenderer) {
        this.fileIO = fileIO;
        this.templateEngine = templateEngine;
        this.propertyManager = propertyManager;
        this.allScenariosPageRenderer = allScenariosPageRenderer;
        this.scenarioDetailsPageRenderer = scenarioDetailsPageRenderer;
    }

    @Override
    public void visit(AllScenariosPageCollection allScenariosPageCollection) throws CluecumberException {
        this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContent(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.ALL_SCENARIOS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/scenario-summary.html");
        this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRenderedContent(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.SCENARIO_SEQUENCE)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/scenario-sequence.html");
        this.fileIO.writeContentToFile(this.allScenariosPageRenderer.getRendererContentByReruns(allScenariosPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.RERUN_SCENARIOS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/rerun-scenarios.html");
        for (Report report : allScenariosPageCollection.getReports()) {
            for (Element element : report.getElements()) {
                this.writeScenarioDetails(element);
                for (Element child : element.getMultiRunChildren()) {
                    this.writeScenarioDetails(child);
                }
            }
        }
    }

    private void writeScenarioDetails(Element element) throws CluecumberException {
        ScenarioDetailsPageCollection scenarioDetailsPageCollection = new ScenarioDetailsPageCollection(element, this.propertyManager.getCustomPageTitle());
        this.fileIO.writeContentToFile(this.scenarioDetailsPageRenderer.getRenderedContent(scenarioDetailsPageCollection, this.templateEngine.getTemplate(TemplateEngine.Template.SCENARIO_DETAILS)), this.propertyManager.getGeneratedHtmlReportDirectory() + "/pages/scenario-detail/scenario_" + element.getScenarioIndex() + ".html");
    }
}

