/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.maven;

import com.trivago.cluecumber.core.CluecumberCore;
import com.trivago.cluecumber.engine.constants.Settings;
import com.trivago.cluecumber.engine.exceptions.CluecumberException;
import com.trivago.cluecumber.engine.logging.CluecumberLogger;
import java.util.LinkedHashMap;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="reporting", requiresProject=false, threadSafe=true)
public final class CluecumberMaven
extends AbstractMojo {
    @Parameter(property="reporting.sourceJsonReportDirectory", required=true)
    private String sourceJsonReportDirectory = "";
    @Parameter(property="reporting.generatedHtmlReportDirectory", required=true)
    private String generatedHtmlReportDirectory = "";
    @Parameter(property="reporting.customParameters")
    private LinkedHashMap<String, String> customParameters = new LinkedHashMap();
    @Parameter(property="reporting.customParametersFile")
    private String customParametersFile = "";
    @Parameter(property="reporting.customParametersDisplayMode", defaultValue="SCENARIO_PAGES")
    private String customParametersDisplayMode = "";
    @Parameter(property="reporting.customNavigationLinks")
    private LinkedHashMap<String, String> customNavigationLinks = new LinkedHashMap();
    @Parameter(property="reporting.failScenariosOnPendingOrUndefinedSteps", defaultValue="false")
    private boolean failScenariosOnPendingOrUndefinedSteps;
    @Parameter(property="reporting.customCss")
    private String customCss = "";
    @Parameter(property="reporting.customFavicon")
    private String customFavicon = "";
    @Parameter(property="reporting.customLogo")
    private String customLogo = "";
    @Parameter(property="reporting.expandOutputs", defaultValue="false")
    private boolean expandOutputs;
    @Parameter(property="reporting.expandSubSections", defaultValue="false")
    private boolean expandSubSections;
    @Parameter(property="reporting.expandBeforeAfterHooks", defaultValue="false")
    private boolean expandBeforeAfterHooks;
    @Parameter(property="reporting.expandStepHooks", defaultValue="false")
    private boolean expandStepHooks;
    @Parameter(property="reporting.groupPreviousScenarioRuns", defaultValue="false")
    private boolean groupPreviousScenarioRuns;
    @Parameter(property="reporting.expandPreviousScenarioRuns", defaultValue="true")
    private boolean expandPreviousScenarioRuns;
    @Parameter(property="reporting.expandDocStrings", defaultValue="false")
    private boolean expandDocStrings;
    @Parameter(property="reporting.expandAttachments", defaultValue="false")
    private boolean expandAttachments;
    @Parameter(property="reporting.customStatusColorPassed")
    private String customStatusColorPassed;
    @Parameter(property="reporting.customStatusColorFailed")
    private String customStatusColorFailed;
    @Parameter(property="reporting.customStatusColorSkipped")
    private String customStatusColorSkipped;
    @Parameter(property="reporting.customPageTitle")
    private String customPageTitle;
    @Parameter(property="reporting.startPage", defaultValue="ALL_SCENARIOS")
    private String startPage;
    @Parameter(property="reporting.logLevel", defaultValue="default")
    String logLevel;
    @Parameter(property="reporting.skip", defaultValue="false")
    private boolean skip;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            System.out.println("Report generation was skipped deliberately.");
            return;
        }
        try {
            new CluecumberCore.Builder().setCustomStatusColorSkipped(this.customStatusColorSkipped).setLogLevel(CluecumberLogger.CluecumberLogLevel.valueOf((String)this.logLevel.toUpperCase())).setCustomCssFile(this.customCss).setCustomFaviconFile(this.customFavicon).setCustomLogoFile(this.customLogo).setCustomNavigationLinks(this.customNavigationLinks).setCustomParameters(this.customParameters).setCustomParametersDisplayMode(Settings.CustomParamDisplayMode.valueOf((String)this.customParametersDisplayMode.toUpperCase())).setCustomParametersFile(this.customParametersFile).setCustomStatusColorFailed(this.customStatusColorFailed).setCustomStatusColorPassed(this.customStatusColorPassed).setExpandSubSections(this.expandSubSections).setExpandOutputs(this.expandOutputs).setExpandAttachments(this.expandAttachments).setExpandBeforeAfterHooks(this.expandBeforeAfterHooks).setExpandDocStrings(this.expandDocStrings).setExpandStepHooks(this.expandStepHooks).setGroupPreviousScenarioRuns(this.groupPreviousScenarioRuns).setExpandPreviousScenarioRuns(this.expandPreviousScenarioRuns).setStartPage(Settings.StartPage.valueOf((String)this.startPage.toUpperCase())).setCustomPageTitle(this.customPageTitle).setCustomStatusColorSkipped(this.customStatusColorSkipped).setCustomParametersFile(this.customParametersFile).setFailScenariosOnPendingOrUndefinedSteps(this.failScenariosOnPendingOrUndefinedSteps).build().generateReports(this.sourceJsonReportDirectory, this.generatedHtmlReportDirectory);
        }
        catch (CluecumberException e) {
            throw new MojoExecutionException(e.getMessage());
        }
    }
}

