/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.json.pojo;

import com.google.gson.annotations.SerializedName;
import java.time.Duration;

public class Result {
    private static final int MICROSECONDS_FACTOR = 1000000;
    private long duration;
    private String status;
    @SerializedName(value="error_message")
    private String errorMessage;
    private transient String durationString;

    public long getDuration() {
        return this.duration;
    }

    public void setDuration(long duration) {
        this.duration = duration;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getStatus() {
        return this.status;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public long getDurationInMilliseconds() {
        return Duration.ofMillis(this.duration / 1000000L).toMillis();
    }

    public String getDurationString() {
        Duration durationMilliseconds = Duration.ofMillis(this.duration / 1000000L);
        long minutes = durationMilliseconds.toMinutes();
        long seconds = durationMilliseconds.minusMinutes(minutes).getSeconds();
        long milliseconds = durationMilliseconds.minusMinutes(minutes).minusSeconds(seconds).toMillis();
        return String.format("%dm %02ds %03dms", minutes, seconds, milliseconds);
    }

    public String toString() {
        return "Result{duration=" + this.duration + ", status='" + this.status + '\'' + ", errorMessage='" + this.errorMessage + '\'' + ", durationString='" + this.durationString + '\'' + '}';
    }
}

