/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.properties;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.exceptions.properties.WrongOrMissingPropertyException;
import com.trivago.rta.logging.CluecumberLogger;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class PropertyManager {
    private final CluecumberLogger logger;
    private String sourceJsonReportDirectory;
    private String generatedHtmlReportDirectory;

    @Inject
    public PropertyManager(CluecumberLogger logger) {
        this.logger = logger;
    }

    public String getSourceJsonReportDirectory() {
        return this.sourceJsonReportDirectory;
    }

    public void setSourceJsonReportDirectory(String reportDirectory) {
        this.sourceJsonReportDirectory = reportDirectory;
    }

    public String getGeneratedHtmlReportDirectory() {
        return this.generatedHtmlReportDirectory;
    }

    public void setGeneratedHtmlReportDirectory(String generatedHtmlReportDirectory) {
        this.generatedHtmlReportDirectory = generatedHtmlReportDirectory;
    }

    public void validateSettings() throws CluecumberPluginException {
        String missingProperty = null;
        if (this.sourceJsonReportDirectory == null || this.sourceJsonReportDirectory.equals("")) {
            missingProperty = "sourceJsonReportDirectory";
        } else if (this.generatedHtmlReportDirectory == null || this.generatedHtmlReportDirectory.equals("")) {
            missingProperty = "generatedHtmlReportDirectory";
        }
        if (missingProperty != null) {
            throw new WrongOrMissingPropertyException(missingProperty);
        }
    }

    public void logProperties() {
        this.logger.info("\u2500 sourceJsonReportDirectory     : " + this.sourceJsonReportDirectory);
        this.logger.info("\u2500 generatedHtmlReportDirectory  : " + this.generatedHtmlReportDirectory);
    }
}

