/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages;

import be.ceau.chart.PieChart;
import be.ceau.chart.color.Color;
import be.ceau.chart.data.PieData;
import be.ceau.chart.dataset.Dataset;
import be.ceau.chart.dataset.PieDataset;
import be.ceau.chart.options.PieOptions;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.constants.Status;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.rendering.pages.PageRenderer;
import com.trivago.rta.rendering.pages.pojos.ReportDetails;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import javax.inject.Singleton;

@Singleton
public class StartPageRenderer
extends PageRenderer {
    public String getRenderedContent(StartPageCollection startPageCollection, Template template) throws CluecumberPluginException {
        ReportDetails reportDetails = new ReportDetails();
        this.addChartJsonToReportDetails(startPageCollection, reportDetails);
        this.addCurrentDateToReportDetails(reportDetails);
        startPageCollection.setReportDetails(reportDetails);
        StringWriter stringWriter = new StringWriter();
        try {
            template.process((Object)startPageCollection, (Writer)stringWriter);
        }
        catch (TemplateException | IOException e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        return ((Object)stringWriter).toString();
    }

    private void addChartJsonToReportDetails(StartPageCollection startPageCollection, ReportDetails reportDetails) {
        PieDataset pieDataset = new PieDataset();
        pieDataset.setData(new int[]{startPageCollection.getTotalNumberOfPassedScenarios(), startPageCollection.getTotalNumberOfFailedScenarios(), startPageCollection.getTotalNumberOfSkippedScenarios()});
        Color passedColor = ChartColor.getChartColorByStatus(Status.PASSED);
        Color failedColor = ChartColor.getChartColorByStatus(Status.FAILED);
        Color skippedColor = ChartColor.getChartColorByStatus(Status.SKIPPED);
        pieDataset.addBackgroundColors(new Color[]{passedColor, failedColor, skippedColor});
        PieData pieData = new PieData();
        pieData.addDataset((Dataset)pieDataset);
        pieData.addLabels(new String[]{Status.PASSED.getStatusString(), Status.FAILED.getStatusString(), Status.SKIPPED.getStatusString()});
        PieOptions pieOptions = new PieOptions();
        reportDetails.setChartJson(new PieChart(pieData, pieOptions).toJson());
    }
}

