/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.json.pojo;

import com.trivago.rta.constants.Status;
import com.trivago.rta.json.pojo.After;
import com.trivago.rta.json.pojo.Before;
import com.trivago.rta.json.pojo.Step;
import com.trivago.rta.json.pojo.Tag;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;

public class Element {
    private List<Before> before = new ArrayList<Before>();
    private int line;
    private String name;
    private String description;
    private String id;
    private List<After> after = new ArrayList<After>();
    private String type;
    private String keyword;
    private List<Step> steps = new ArrayList<Step>();
    private List<Tag> tags = new ArrayList<Tag>();
    private transient int scenarioIndex;
    private transient String durationChartJson = "";

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public List<Before> getBefore() {
        return this.before;
    }

    public void setBefore(List<Before> before) {
        this.before = before;
    }

    public int getLine() {
        return this.line;
    }

    public void setLine(int line) {
        this.line = line;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public List<After> getAfter() {
        return this.after;
    }

    public void setAfter(List<After> after) {
        this.after = after;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getKeyword() {
        return this.keyword;
    }

    public void setKeyword(String keyword) {
        this.keyword = keyword;
    }

    public List<Step> getSteps() {
        return this.steps;
    }

    public void setSteps(List<Step> steps) {
        this.steps = steps;
    }

    public boolean isScenario() {
        return this.type.equals("scenario");
    }

    public boolean isFailed() {
        return this.getStatus() == Status.FAILED;
    }

    public boolean isPassed() {
        return this.getStatus() == Status.PASSED;
    }

    public boolean isSkipped() {
        return this.getStatus() == Status.SKIPPED;
    }

    public Status getStatus() {
        int totalSteps = this.steps.size();
        if (totalSteps == 0) {
            return Status.SKIPPED;
        }
        for (Status status : Status.values()) {
            int stepNumber = (int)this.steps.stream().filter(step -> step.getStatus() == status).count();
            if (totalSteps != stepNumber) continue;
            if (status != Status.UNDEFINED) {
                return status;
            }
            return Status.SKIPPED;
        }
        return Status.FAILED;
    }

    public int getScenarioIndex() {
        return this.scenarioIndex;
    }

    public void setScenarioIndex(int scenarioIndex) {
        this.scenarioIndex = scenarioIndex;
    }

    public String getTotalDurationString() {
        long totalDurationMillis = 0L;
        for (Step step : this.steps) {
            totalDurationMillis += step.getResult().getDuration();
        }
        int microsecondFactor = 1000000;
        Duration durationMilliseconds = Duration.ofMillis(totalDurationMillis / 1000000L);
        long minutes = durationMilliseconds.toMinutes();
        long seconds = durationMilliseconds.minusMinutes(minutes).getSeconds();
        long milliseconds = durationMilliseconds.minusMinutes(minutes).minusSeconds(seconds).toMillis();
        return String.format("%dm %02ds %03dms", minutes, seconds, milliseconds);
    }

    public String toString() {
        return "Element{before=" + this.before + ", line=" + this.line + ", name='" + this.name + '\'' + ", description='" + this.description + '\'' + ", id='" + this.id + '\'' + ", after=" + this.after + ", type='" + this.type + '\'' + ", keyword='" + this.keyword + '\'' + ", steps=" + this.steps + ", tags=" + this.tags + ", scenarioIndex=" + this.scenarioIndex + '}';
    }
}

