/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.pojos;

import com.trivago.rta.constants.Status;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.rendering.pages.pojos.ReportDetails;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class StartPageCollection {
    private List<Report> reports = new ArrayList<Report>();
    private ReportDetails reportDetails;

    public List<Report> getReports() {
        return this.reports;
    }

    public void addReports(Report[] reportList) {
        this.reports.addAll(Arrays.asList(reportList));
    }

    public int getTotalNumberOfFeatures() {
        return this.reports.size();
    }

    public int getTotalNumberOfScenarios() {
        return this.reports.stream().map(Report::getElements).mapToInt(elements -> (int)elements.stream().filter(Element::isScenario).count()).sum();
    }

    public boolean hasFailedScenarios() {
        return this.getTotalNumberOfFailedScenarios() > 0;
    }

    public boolean hasPassedScenarios() {
        return this.getTotalNumberOfPassedScenarios() > 0;
    }

    public boolean hasSkippedScenarios() {
        return this.getTotalNumberOfSkippedScenarios() > 0;
    }

    public int getTotalNumberOfPassedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.FAILED);
    }

    public int getTotalNumberOfSkippedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.SKIPPED);
    }

    private int getNumberOfScenariosWithStatus(Status status) {
        return this.reports.stream().mapToInt(report -> (int)report.getElements().stream().filter(element -> element.getStatus().equals((Object)status)).count()).sum();
    }

    public ReportDetails getReportDetails() {
        return this.reportDetails;
    }

    public void setReportDetails(ReportDetails reportDetails) {
        this.reportDetails = reportDetails;
    }
}

