/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.filesystem;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.exceptions.filesystem.PathCreationException;
import com.trivago.rta.properties.PropertyManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileSystemManager {
    public static final int BYTE_BLOCK = 4096;
    private final PropertyManager propertyManager;

    @Inject
    public FileSystemManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public List<Path> getJsonFilePaths() throws CluecumberPluginException {
        List<Path> jsonFilePaths;
        String sourceJsonReportDirectory = this.propertyManager.getSourceJsonReportDirectory();
        try {
            jsonFilePaths = Files.walk(Paths.get(sourceJsonReportDirectory, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CluecumberPluginException("Unable to traverse JSON files in " + sourceJsonReportDirectory);
        }
        return jsonFilePaths;
    }

    public void createDirectory(String dirName) throws PathCreationException {
        File directory = new File(dirName);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new PathCreationException(dirName);
        }
    }

    public void exportResource(Class baseClass, String resourceName, String destination) throws CluecumberPluginException {
        InputStream stream = null;
        OutputStream resStreamOut = null;
        try {
            int readBytes;
            stream = baseClass.getResourceAsStream(resourceName);
            if (stream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\" from Jar file.");
            }
            byte[] buffer = new byte[4096];
            resStreamOut = new FileOutputStream(destination);
            while ((readBytes = stream.read(buffer)) > 0) {
                resStreamOut.write(buffer, 0, readBytes);
            }
        }
        catch (Exception e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
                if (resStreamOut != null) {
                    resStreamOut.close();
                }
            }
            catch (IOException e) {
                throw new CluecumberPluginException(e.getMessage());
            }
        }
    }
}

