/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.json;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.postprocessors.ElementPostProcessor;
import io.gsonfire.GsonFireBuilder;
import io.gsonfire.PostProcessor;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class JsonPojoConverter {
    private final Gson gsonParser;

    @Inject
    public JsonPojoConverter(ElementPostProcessor elementPostProcessor) {
        GsonFireBuilder builder = new GsonFireBuilder().registerPostProcessor(Element.class, (PostProcessor)elementPostProcessor);
        this.gsonParser = builder.createGson();
    }

    public Report[] convertJsonToReportPojos(String json) throws CluecumberPluginException {
        Report[] reports = null;
        try {
            reports = (Report[])this.gsonParser.fromJson(json, Report[].class);
        }
        catch (JsonParseException e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        return reports;
    }
}

