/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages;

import be.ceau.chart.BarChart;
import be.ceau.chart.data.BarData;
import be.ceau.chart.dataset.BarDataset;
import be.ceau.chart.dataset.Dataset;
import be.ceau.chart.options.BarOptions;
import be.ceau.chart.options.scales.BarScale;
import be.ceau.chart.options.ticks.LinearTicks;
import be.ceau.chart.options.ticks.Ticks;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Step;
import com.trivago.rta.rendering.pages.PageRenderer;
import com.trivago.rta.rendering.pages.pojos.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.ReportDetails;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class DetailPageRenderer
extends PageRenderer {
    public String getRenderedContent(DetailPageCollection detailPageCollection, Template template) throws CluecumberPluginException {
        ReportDetails reportDetails = new ReportDetails();
        this.addChartJsonToReportDetails(detailPageCollection.getElement(), reportDetails);
        this.addCurrentDateToReportDetails(reportDetails);
        detailPageCollection.setReportDetails(reportDetails);
        StringWriter stringWriter = new StringWriter();
        try {
            template.process((Object)detailPageCollection, (Writer)stringWriter);
        }
        catch (TemplateException | IOException e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        return ((Object)stringWriter).toString();
    }

    private void addChartJsonToReportDetails(Element element, ReportDetails reportDetails) {
        BarDataset barDataSet = new BarDataset();
        BarData barData = new BarData();
        int stepCounter = 1;
        for (Step step : element.getSteps()) {
            barData.addLabel("Step " + stepCounter);
            barDataSet.addData((double)step.getResult().getDurationInMilliseconds());
            barDataSet.addBackgroundColor(ChartColor.getChartColorByStatus(step.getStatus()));
            ++stepCounter;
        }
        barDataSet.setLabel("Step runtime");
        barData.addDataset((Dataset)barDataSet);
        LinearTicks ticks = new LinearTicks().setMin(0);
        BarScale scale = new BarScale().addyAxes(BarScale.yAxis().setTicks((Ticks)ticks));
        BarOptions barOptions = new BarOptions().setScales(scale);
        reportDetails.setChartJson(new BarChart(barData, barOptions).toJson());
    }
}

