/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.rendering.TemplateConfiguration;
import com.trivago.rta.rendering.pages.DetailPageRenderer;
import com.trivago.rta.rendering.pages.StartPageRenderer;
import com.trivago.rta.rendering.pages.pojos.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TemplateEngine {
    private TemplateConfiguration templateConfiguration;
    private final StartPageRenderer startPageRenderer;
    private final DetailPageRenderer detailPageRenderer;

    @Inject
    public TemplateEngine(TemplateConfiguration templateConfiguration, StartPageRenderer startPageRenderer, DetailPageRenderer detailPageRenderer) {
        this.templateConfiguration = templateConfiguration;
        this.startPageRenderer = startPageRenderer;
        this.detailPageRenderer = detailPageRenderer;
    }

    void init(Class rootClass, String basePath) {
        this.templateConfiguration.init(rootClass, basePath);
    }

    String getRenderedStartPage(StartPageCollection startPageCollection) throws CluecumberPluginException {
        return this.startPageRenderer.getRenderedContent(startPageCollection, this.templateConfiguration.getTemplate("index.html"));
    }

    String getRenderedDetailPage(DetailPageCollection detailPageCollection) throws CluecumberPluginException {
        return this.detailPageRenderer.getRenderedContent(detailPageCollection, this.templateConfiguration.getTemplate("scenario-detail/detail.html"));
    }
}

