/*
 * Decompiled with CFR 0.152.
 */
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.filesystem.FileIO;
import com.trivago.rta.filesystem.FileSystemManager;
import com.trivago.rta.json.JsonPojoConverter;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.logging.CluecumberLogger;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.ReportGenerator;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;

@Mojo(name="reporting")
public final class CluecumberReportPlugin
extends AbstractMojo {
    private final CluecumberLogger logger;
    private final PropertyManager propertyManager;
    private final FileSystemManager fileSystemManager;
    private final FileIO fileIO;
    private final JsonPojoConverter jsonPojoConverter;
    private final ReportGenerator reportGenerator;
    @Parameter(property="reporting.sourceJsonReportDirectory", required=true)
    private String sourceJsonReportDirectory = "";
    @Parameter(property="reporting.generatedHtmlReportDirectory", required=true)
    private String generatedHtmlReportDirectory = "";
    @Parameter(property="reporting.customParameters", required=true)
    private Map<String, String> customParameters;

    @Inject
    public CluecumberReportPlugin(CluecumberLogger logger, PropertyManager propertyManager, FileSystemManager fileSystemManager, FileIO fileIO, JsonPojoConverter jsonPojoConverter, ReportGenerator reportGenerator) {
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.fileIO = fileIO;
        this.jsonPojoConverter = jsonPojoConverter;
        this.logger = logger;
        this.reportGenerator = reportGenerator;
    }

    public void execute() throws CluecumberPluginException {
        this.logger.setMojoLogger(this.getLog());
        this.propertyManager.setSourceJsonReportDirectory(this.sourceJsonReportDirectory);
        this.propertyManager.setGeneratedHtmlReportDirectory(this.generatedHtmlReportDirectory);
        this.propertyManager.setCustomParameters(this.customParameters);
        this.propertyManager.validateSettings();
        this.logger.info("--------------------------------");
        this.logger.info(" Cluecumber Report Maven Plugin ");
        this.logger.info("--------------------------------");
        this.propertyManager.logProperties();
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments");
        StartPageCollection startPageCollection = new StartPageCollection();
        List<Path> jsonFilePaths = this.fileSystemManager.getJsonFilePaths();
        for (Path jsonFilePath : jsonFilePaths) {
            String jsonString = this.fileIO.readContentFromFile(jsonFilePath.toString());
            try {
                Report[] reports = this.jsonPojoConverter.convertJsonToReportPojos(jsonString);
                startPageCollection.addReports(reports);
            }
            catch (CluecumberPluginException e) {
                this.logger.error("Could not parse JSON in file '" + jsonFilePath.toString() + "': " + e.getMessage());
            }
        }
        this.reportGenerator.generateReports(startPageCollection);
        this.logger.info("Converted " + startPageCollection.getTotalNumberOfFeatures() + " features into test report:");
        this.logger.info("- " + this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index.html");
    }
}

