/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.exceptions.filesystem.FileCreationException;
import com.trivago.rta.filesystem.FileIO;
import com.trivago.rta.filesystem.FileSystemManager;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.logging.CluecumberLogger;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.TemplateEngine;
import com.trivago.rta.rendering.pages.pojos.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportGenerator {
    private static final String BASE_PACKAGE_PATH = "/template";
    private static final String SCENARIO_DETAIL_DIR = "/scenario-detail";
    private TemplateEngine templateEngine;
    private FileIO fileIO;
    private PropertyManager propertyManager;
    private FileSystemManager fileSystemManager;

    @Inject
    public ReportGenerator(TemplateEngine templateEngine, FileIO fileIO, PropertyManager propertyManager, FileSystemManager fileSystemManager, CluecumberLogger logger) {
        this.templateEngine = templateEngine;
        this.fileIO = fileIO;
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
    }

    public void generateReports(StartPageCollection startPageCollection) throws CluecumberPluginException {
        this.templateEngine.init(this.getClass(), BASE_PACKAGE_PATH);
        this.copyResources();
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + SCENARIO_DETAIL_DIR);
        List<Report> reports = startPageCollection.getReports();
        for (Report report : reports) {
            for (Element element : report.getElements()) {
                DetailPageCollection detailPageCollection = new DetailPageCollection(element);
                String renderedDetailPage = this.templateEngine.getRenderedDetailPage(detailPageCollection);
                this.savePage(renderedDetailPage, "/scenario-detail/scenario_" + element.getScenarioIndex() + ".html");
            }
        }
        String renderedStartPage = this.templateEngine.getRenderedStartPage(startPageCollection);
        this.fileIO.writeContentToFile(renderedStartPage, this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index.html");
    }

    private void savePage(String renderedDetailPage, String fileName) throws FileCreationException {
        this.fileIO.writeContentToFile(renderedDetailPage, this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + fileName);
    }

    private void copyResources() throws CluecumberPluginException {
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory());
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/js");
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/img");
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/css");
        this.copyResource("/css/bootstrap.min.css");
        this.copyResource("/css/cluecumber.css");
        this.copyResource("/css/dataTables.bootstrap4.min.css");
        this.copyResource("/css/jquery.fancybox.min.css");
        this.copyResource("/js/jquery-3.2.1.slim.min.js");
        this.copyResource("/js/bootstrap.min.js");
        this.copyResource("/js/popper.min.js");
        this.copyResource("/js/Chart.bundle.min.js");
        this.copyResource("/js/dataTables.bootstrap4.min.js");
        this.copyResource("/js/jquery.dataTables.min.js");
        this.copyResource("/js/jquery.fancybox.min.js");
    }

    private void copyResource(String fileName) throws CluecumberPluginException {
        this.fileSystemManager.exportResource(this.getClass(), BASE_PACKAGE_PATH + fileName, this.propertyManager.getGeneratedHtmlReportDirectory() + fileName);
    }
}

