/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.json.postprocessors;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.exceptions.filesystem.FileCreationException;
import com.trivago.rta.filesystem.FileIO;
import com.trivago.rta.json.pojo.After;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Embedding;
import com.trivago.rta.json.pojo.Step;
import com.trivago.rta.logging.CluecumberLogger;
import com.trivago.rta.properties.PropertyManager;
import io.gsonfire.PostProcessor;
import java.nio.charset.StandardCharsets;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.codehaus.plexus.util.Base64;

@Singleton
public class ElementPostProcessor
implements PostProcessor<Element> {
    private final PropertyManager propertyManager;
    private final FileIO fileIO;
    private CluecumberLogger logger;
    private int scenarioIndex = 0;
    private int attachmentIndex = 0;

    @Inject
    public ElementPostProcessor(PropertyManager propertyManager, FileIO fileIO, CluecumberLogger logger) {
        this.propertyManager = propertyManager;
        this.fileIO = fileIO;
        this.logger = logger;
    }

    public void postDeserialize(Element element, JsonElement jsonElement, Gson gson) {
        this.addScenarioIndex(element);
        try {
            this.processAttachments(element.getSteps(), element.getAfter());
        }
        catch (CluecumberPluginException e) {
            this.logger.error(e.getMessage());
        }
    }

    private void processAttachments(List<Step> steps, List<After> afterHooks) throws CluecumberPluginException {
        for (Step step : steps) {
            this.processEmbedding(step.getEmbeddings());
        }
        for (After afterHook : afterHooks) {
            this.processEmbedding(afterHook.getEmbeddings());
        }
    }

    private void processEmbedding(List<Embedding> embeddings) throws CluecumberPluginException {
        for (Embedding embedding : embeddings) {
            if (embedding.isImage()) {
                String filename = this.saveImageEmbeddingToFileAndGetFilename(embedding);
                embedding.setFilename(filename);
            }
            ++this.attachmentIndex;
        }
    }

    private String saveImageEmbeddingToFileAndGetFilename(Embedding embedding) throws CluecumberPluginException {
        String fileEnding;
        if (!embedding.isImage()) {
            return "";
        }
        switch (embedding.getMimeType()) {
            case "image/png": {
                fileEnding = ".png";
                break;
            }
            case "image/jpeg": {
                fileEnding = ".jpg";
                break;
            }
            case "image/gif": {
                fileEnding = ".gif";
                break;
            }
            case "image/svg+xml": {
                fileEnding = "svg";
                break;
            }
            default: {
                fileEnding = ".unknown";
            }
        }
        byte[] dataBytes = Base64.decodeBase64((byte[])embedding.getData().getBytes(StandardCharsets.UTF_8));
        embedding.setData("");
        String filename = String.format("attachment%03d%s", this.attachmentIndex, fileEnding);
        try {
            this.fileIO.writeContentToFile(dataBytes, this.propertyManager.getGeneratedHtmlReportDirectory() + "/attachments/" + filename);
        }
        catch (FileCreationException e) {
            this.logger.error("Could not process image " + filename + " but will continue report generation...");
        }
        return filename;
    }

    private void addScenarioIndex(Element element) {
        element.setScenarioIndex(this.scenarioIndex);
        ++this.scenarioIndex;
    }

    public void postSerialize(JsonElement jsonElement, Element element, Gson gson) {
    }
}

