/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages;

import be.ceau.chart.PieChart;
import be.ceau.chart.color.Color;
import be.ceau.chart.data.PieData;
import be.ceau.chart.dataset.Dataset;
import be.ceau.chart.dataset.PieDataset;
import be.ceau.chart.options.PieOptions;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.constants.Status;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.pages.PageRenderer;
import com.trivago.rta.rendering.pages.pojos.CustomParameter;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class StartPageRenderer
extends PageRenderer {
    private PropertyManager propertyManager;

    @Inject
    public StartPageRenderer(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public String getRenderedContent(StartPageCollection startPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(startPageCollection);
        this.addCustomParametersToReportDetails(startPageCollection);
        return this.processedContent(template, startPageCollection);
    }

    private void addChartJsonToReportDetails(StartPageCollection startPageCollection) {
        PieDataset pieDataset = new PieDataset();
        pieDataset.setData(new int[]{startPageCollection.getTotalNumberOfPassedScenarios(), startPageCollection.getTotalNumberOfFailedScenarios(), startPageCollection.getTotalNumberOfSkippedScenarios()});
        Color passedColor = ChartColor.getChartColorByStatus(Status.PASSED);
        Color failedColor = ChartColor.getChartColorByStatus(Status.FAILED);
        Color skippedColor = ChartColor.getChartColorByStatus(Status.SKIPPED);
        pieDataset.addBackgroundColors(new Color[]{passedColor, failedColor, skippedColor});
        PieData pieData = new PieData();
        pieData.addDataset((Dataset)pieDataset);
        pieData.addLabels(new String[]{Status.PASSED.getStatusString(), Status.FAILED.getStatusString(), Status.SKIPPED.getStatusString()});
        PieOptions pieOptions = new PieOptions();
        startPageCollection.getReportDetails().setChartJson(new PieChart(pieData, pieOptions).toJson());
    }

    private void addCustomParametersToReportDetails(StartPageCollection startPageCollection) {
        Map<String, String> customParameterMap = this.propertyManager.getCustomParameters();
        if (customParameterMap == null || customParameterMap.isEmpty()) {
            return;
        }
        ArrayList<CustomParameter> customParameters = new ArrayList<CustomParameter>();
        for (Map.Entry<String, String> stringStringEntry : customParameterMap.entrySet()) {
            String key = stringStringEntry.getKey().replace("_", " ");
            CustomParameter customParameter = new CustomParameter(key, stringStringEntry.getValue());
            customParameters.add(customParameter);
        }
        startPageCollection.setCustomParameters(customParameters);
    }
}

