/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.filesystem.FileIO;
import com.trivago.rta.filesystem.FileSystemManager;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.logging.CluecumberLogger;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.TemplateEngine;
import com.trivago.rta.rendering.pages.pojos.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import com.trivago.rta.rendering.pages.pojos.TagSummaryPageCollection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportGenerator {
    private TemplateEngine templateEngine;
    private FileIO fileIO;
    private PropertyManager propertyManager;
    private FileSystemManager fileSystemManager;
    private CluecumberLogger logger;

    @Inject
    public ReportGenerator(TemplateEngine templateEngine, FileIO fileIO, PropertyManager propertyManager, FileSystemManager fileSystemManager, CluecumberLogger logger) {
        this.templateEngine = templateEngine;
        this.fileIO = fileIO;
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.logger = logger;
    }

    public void generateReport(StartPageCollection startPageCollection) throws CluecumberPluginException {
        this.copyReportAssets();
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages");
        this.generateScenarioDetailPages(startPageCollection.getReports());
        this.generateStartPage(startPageCollection);
        this.generateTagSummaryPage(startPageCollection.getReports());
    }

    private void generateTagSummaryPage(List<Report> reports) throws CluecumberPluginException {
        TagSummaryPageCollection tagSummaryPageCollection = new TagSummaryPageCollection(reports);
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedTagSummaryPageContent(tagSummaryPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "tag-summary" + ".html");
    }

    private void generateStartPage(StartPageCollection startPageCollection) throws CluecumberPluginException {
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedStartPageContent(startPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index" + ".html");
    }

    private void generateScenarioDetailPages(List<Report> reports) throws CluecumberPluginException {
        for (Report report : reports) {
            for (Element element : report.getElements()) {
                DetailPageCollection detailPageCollection = new DetailPageCollection(element);
                this.fileIO.writeContentToFile(this.templateEngine.getRenderedDetailPageContent(detailPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/scenario-detail/scenario_" + element.getScenarioIndex() + ".html");
            }
        }
    }

    private void copyReportAssets() throws CluecumberPluginException {
        String reportDirectory = this.propertyManager.getGeneratedHtmlReportDirectory();
        this.fileSystemManager.createDirectory(reportDirectory);
        this.fileSystemManager.createDirectory(reportDirectory + "/js");
        this.fileSystemManager.createDirectory(reportDirectory + "/img");
        this.fileSystemManager.createDirectory(reportDirectory + "/css");
        this.copyFileFromJarToFilesystem("/css/bootstrap.min.css");
        this.copyFileFromJarToFilesystem("/css/cluecumber.css");
        this.copyFileFromJarToFilesystem("/css/datatables.min.css");
        this.copyFileFromJarToFilesystem("/css/jquery.fancybox.min.css");
        this.copyFileFromJarToFilesystem("/css/dataTables.bootstrap4.min.css");
        this.copyFileFromJarToFilesystem("/js/jquery.min.js");
        this.copyFileFromJarToFilesystem("/js/bootstrap.min.js");
        this.copyFileFromJarToFilesystem("/js/popper.min.js");
        this.copyFileFromJarToFilesystem("/js/Chart.bundle.min.js");
        this.copyFileFromJarToFilesystem("/js/datatables.min.js");
        this.copyFileFromJarToFilesystem("/js/jquery.fancybox.min.js");
    }

    private void copyFileFromJarToFilesystem(String fileName) throws CluecumberPluginException {
        this.fileSystemManager.exportResource(this.getClass(), "/template" + fileName, this.propertyManager.getGeneratedHtmlReportDirectory() + fileName);
    }
}

