/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.rendering.TemplateConfiguration;
import com.trivago.rta.rendering.pages.ScenarioDetailPageRenderer;
import com.trivago.rta.rendering.pages.StartPageRenderer;
import com.trivago.rta.rendering.pages.TagSummaryPageRenderer;
import com.trivago.rta.rendering.pages.pojos.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.StartPageCollection;
import com.trivago.rta.rendering.pages.pojos.TagSummaryPageCollection;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TemplateEngine {
    private final TemplateConfiguration templateConfiguration;
    private final StartPageRenderer startPageRenderer;
    private final ScenarioDetailPageRenderer scenarioDetailPageRenderer;
    private final TagSummaryPageRenderer tagSummaryPageRenderer;

    @Inject
    public TemplateEngine(TemplateConfiguration templateConfiguration, StartPageRenderer startPageRenderer, ScenarioDetailPageRenderer scenarioDetailPageRenderer, TagSummaryPageRenderer tagSummaryPageRenderer) {
        this.templateConfiguration = templateConfiguration;
        templateConfiguration.init(this.getClass(), "/template");
        this.startPageRenderer = startPageRenderer;
        this.scenarioDetailPageRenderer = scenarioDetailPageRenderer;
        this.tagSummaryPageRenderer = tagSummaryPageRenderer;
    }

    String getRenderedStartPageContent(StartPageCollection startPageCollection) throws CluecumberPluginException {
        return this.startPageRenderer.getRenderedContent(startPageCollection, this.templateConfiguration.getTemplate("index"));
    }

    String getRenderedDetailPageContent(DetailPageCollection detailPageCollection) throws CluecumberPluginException {
        return this.scenarioDetailPageRenderer.getRenderedContent(detailPageCollection, this.templateConfiguration.getTemplate("scenario-detail"));
    }

    String getRenderedTagSummaryPageContent(TagSummaryPageCollection tagSummaryPageCollection) throws CluecumberPluginException {
        return this.tagSummaryPageRenderer.getRenderedContent(tagSummaryPageCollection, this.templateConfiguration.getTemplate("tag-summary"));
    }
}

