/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import java.time.Duration;

public class RenderingUtils {
    private static final int MICROSECOND_FACTOR = 1000000;

    public static String convertMicrosecondsToTimeString(long microseconds) {
        Duration durationMilliseconds = Duration.ofMillis(microseconds / 1000000L);
        long minutes = durationMilliseconds.toMinutes();
        long seconds = durationMilliseconds.minusMinutes(minutes).getSeconds();
        long milliseconds = durationMilliseconds.minusMinutes(minutes).minusSeconds(seconds).toMillis();
        return String.format("%dm %02ds %03dms", minutes, seconds, milliseconds);
    }

    public static long convertMicrosecondsToMilliseconds(long microseconds) {
        return Duration.ofMillis(microseconds / 1000000L).toMillis();
    }

    public static String getPluginVersion() {
        String version = RenderingUtils.class.getPackage().getImplementationVersion();
        if (version == null) {
            version = "unknown";
        }
        return version;
    }
}

