/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.filesystem;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.exceptions.filesystem.PathCreationException;
import com.trivago.rta.properties.PropertyManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class FileSystemManager {
    private static final int BYTE_BLOCK = 4096;
    private final PropertyManager propertyManager;

    @Inject
    public FileSystemManager(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
    }

    public List<Path> getJsonFilePaths() throws CluecumberPluginException {
        List<Path> jsonFilePaths;
        String sourceJsonReportDirectory = this.propertyManager.getSourceJsonReportDirectory();
        try {
            jsonFilePaths = Files.walk(Paths.get(sourceJsonReportDirectory, new String[0]), new FileVisitOption[0]).filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).filter(p -> p.toString().endsWith(".json")).collect(Collectors.toList());
        }
        catch (IOException e) {
            throw new CluecumberPluginException("Unable to traverse JSON files in " + sourceJsonReportDirectory);
        }
        return jsonFilePaths;
    }

    public void createDirectory(String dirName) throws PathCreationException {
        File directory = new File(dirName);
        if (!directory.exists() && !directory.mkdirs()) {
            throw new PathCreationException(dirName);
        }
    }

    public void exportResource(Class baseClass, String resourceName, String destination) throws CluecumberPluginException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int readBytes;
            inputStream = baseClass.getResourceAsStream(resourceName);
            if (inputStream == null) {
                throw new Exception("Cannot get resource \"" + resourceName + "\".");
            }
            byte[] buffer = new byte[4096];
            outputStream = new FileOutputStream(destination);
            while ((readBytes = inputStream.read(buffer)) > 0) {
                outputStream.write(buffer, 0, readBytes);
            }
        }
        catch (Exception e) {
            throw new CluecumberPluginException(e.getMessage());
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException e) {
                throw new CluecumberPluginException(e.getMessage());
            }
        }
    }
}

