/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.pojos;

import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.rendering.pages.pojos.PageCollection;
import com.trivago.rta.rendering.pages.pojos.TagStat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class TagSummaryPageCollection
extends PageCollection {
    private List<Report> reports;

    public TagSummaryPageCollection(List<Report> reports) {
        super("Tag Summary");
        this.reports = reports;
    }

    public Map<String, TagStat> getTagStats() {
        HashMap<String, TagStat> tagStats = new HashMap<String, TagStat>();
        for (Report report : this.reports) {
            for (Element element : report.getElements()) {
                for (Tag tag : element.getTags()) {
                    TagStat tagStat = (TagStat)tagStats.get(tag.getName());
                    if (tagStat == null) {
                        tagStat = new TagStat();
                    }
                    switch (element.getStatus()) {
                        case PASSED: {
                            tagStat.addPassed(1);
                            break;
                        }
                        case FAILED: {
                            tagStat.addFailed(1);
                            break;
                        }
                        case SKIPPED: 
                        case PENDING: 
                        case UNDEFINED: 
                        case AMBIGUOUS: {
                            tagStat.addSkipped(1);
                        }
                    }
                    tagStats.put(tag.getName(), tagStat);
                }
            }
        }
        return tagStats;
    }
}

