/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.filesystem.FileIO;
import com.trivago.rta.filesystem.FileSystemManager;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.logging.CluecumberLogger;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.TemplateEngine;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.FeatureSummaryPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.ScenarioSummaryPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.TagSummaryPageCollection;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ReportGenerator {
    private TemplateEngine templateEngine;
    private FileIO fileIO;
    private PropertyManager propertyManager;
    private FileSystemManager fileSystemManager;
    private CluecumberLogger logger;

    @Inject
    public ReportGenerator(TemplateEngine templateEngine, FileIO fileIO, PropertyManager propertyManager, FileSystemManager fileSystemManager, CluecumberLogger logger) {
        this.templateEngine = templateEngine;
        this.fileIO = fileIO;
        this.propertyManager = propertyManager;
        this.fileSystemManager = fileSystemManager;
        this.logger = logger;
    }

    public void generateReport(ScenarioSummaryPageCollection scenarioSummaryPageCollection) throws CluecumberPluginException {
        this.copyReportAssets();
        this.generateScenarioDetailPages(scenarioSummaryPageCollection);
        this.generateFeaturePages(scenarioSummaryPageCollection);
        this.generateTagPages(scenarioSummaryPageCollection);
        this.generateScenarioSummaryPage(scenarioSummaryPageCollection);
    }

    private void generateFeaturePages(ScenarioSummaryPageCollection scenarioSummaryPageCollection) throws CluecumberPluginException {
        FeatureSummaryPageCollection featureSummaryPageCollection = new FeatureSummaryPageCollection(scenarioSummaryPageCollection.getReports());
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedFeatureSummaryPageContent(featureSummaryPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "feature-summary" + ".html");
        for (Feature feature : featureSummaryPageCollection.getFeatures()) {
            this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioSummaryPageContentByFeatureFilter(scenarioSummaryPageCollection, feature), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/feature-scenarios/feature_" + feature.getIndex() + ".html");
        }
    }

    private void generateTagPages(ScenarioSummaryPageCollection scenarioSummaryPageCollection) throws CluecumberPluginException {
        TagSummaryPageCollection tagSummaryPageCollection = new TagSummaryPageCollection(scenarioSummaryPageCollection.getReports());
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedTagSummaryPageContent(tagSummaryPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/" + "tag-summary" + ".html");
        for (Tag tag : tagSummaryPageCollection.getTags()) {
            this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioSummaryPageContentByTagFilter(scenarioSummaryPageCollection, tag), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/tag-scenarios/tag_" + tag.getUrlFriendlyName() + ".html");
        }
    }

    private void generateScenarioDetailPages(ScenarioSummaryPageCollection scenarioSummaryPageCollection) throws CluecumberPluginException {
        for (Report report : scenarioSummaryPageCollection.getReports()) {
            for (Element element : report.getElements()) {
                DetailPageCollection detailPageCollection = new DetailPageCollection(element);
                this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioDetailPageContent(detailPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages" + "/scenario-detail/scenario_" + element.getScenarioIndex() + ".html");
            }
        }
    }

    private void generateScenarioSummaryPage(ScenarioSummaryPageCollection scenarioSummaryPageCollection) throws CluecumberPluginException {
        this.fileIO.writeContentToFile(this.templateEngine.getRenderedScenarioSummaryPageContent(scenarioSummaryPageCollection), this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "index" + ".html");
    }

    private void copyReportAssets() throws CluecumberPluginException {
        String reportDirectory = this.propertyManager.getGeneratedHtmlReportDirectory();
        this.fileSystemManager.createDirectory(reportDirectory);
        this.fileSystemManager.createDirectory(this.propertyManager.getGeneratedHtmlReportDirectory() + "/" + "pages");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "scenario-detail");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "feature-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/" + "pages" + "/" + "tag-scenarios");
        this.fileSystemManager.createDirectory(reportDirectory + "/js");
        this.fileSystemManager.createDirectory(reportDirectory + "/css");
        this.copyFileFromJarToReportDirectory("/css/bootstrap.min.css");
        this.copyFileFromJarToReportDirectory("/css/cluecumber.css");
        this.copyFileFromJarToReportDirectory("/css/datatables.min.css");
        this.copyFileFromJarToReportDirectory("/css/jquery.fancybox.min.css");
        this.copyFileFromJarToReportDirectory("/css/dataTables.bootstrap4.min.css");
        this.copyFileFromJarToReportDirectory("/js/jquery.min.js");
        this.copyFileFromJarToReportDirectory("/js/bootstrap.min.js");
        this.copyFileFromJarToReportDirectory("/js/popper.min.js");
        this.copyFileFromJarToReportDirectory("/js/Chart.bundle.min.js");
        this.copyFileFromJarToReportDirectory("/js/datatables.min.js");
        this.copyFileFromJarToReportDirectory("/js/jquery.fancybox.min.js");
    }

    private void copyFileFromJarToReportDirectory(String fileName) throws CluecumberPluginException {
        this.fileSystemManager.exportResource(this.getClass(), "/template" + fileName, this.propertyManager.getGeneratedHtmlReportDirectory() + fileName);
    }
}

