/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering;

import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.rendering.RenderingUtils;
import com.trivago.rta.rendering.TemplateConfiguration;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.DetailPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.FeatureSummaryPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.ScenarioSummaryPageCollection;
import com.trivago.rta.rendering.pages.pojos.pagecollections.TagSummaryPageCollection;
import com.trivago.rta.rendering.pages.renderers.FeatureSummaryPageRenderer;
import com.trivago.rta.rendering.pages.renderers.ScenarioDetailPageRenderer;
import com.trivago.rta.rendering.pages.renderers.ScenarioSummaryPageRenderer;
import com.trivago.rta.rendering.pages.renderers.TagSummaryPageRenderer;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TemplateEngine {
    private final TemplateConfiguration templateConfiguration;
    private final FeatureSummaryPageRenderer featureSummaryPageRenderer;
    private final TagSummaryPageRenderer tagSummaryPageRenderer;
    private final ScenarioDetailPageRenderer scenarioDetailPageRenderer;
    private final ScenarioSummaryPageRenderer scenarioSummaryPageRenderer;

    @Inject
    public TemplateEngine(TemplateConfiguration templateConfiguration, FeatureSummaryPageRenderer featureSummaryPageRenderer, TagSummaryPageRenderer tagSummaryPageRenderer, ScenarioDetailPageRenderer scenarioDetailPageRenderer, ScenarioSummaryPageRenderer scenarioSummaryPageRenderer) {
        this.templateConfiguration = templateConfiguration;
        this.featureSummaryPageRenderer = featureSummaryPageRenderer;
        this.scenarioSummaryPageRenderer = scenarioSummaryPageRenderer;
        this.scenarioDetailPageRenderer = scenarioDetailPageRenderer;
        this.tagSummaryPageRenderer = tagSummaryPageRenderer;
        templateConfiguration.init(this.getClass(), "/template");
    }

    String getRenderedScenarioSummaryPageContent(ScenarioSummaryPageCollection scenarioSummaryPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.scenarioSummaryPageRenderer.getRenderedContent(scenarioSummaryPageCollection, this.templateConfiguration.getTemplate("scenario-summary")));
    }

    String getRenderedScenarioSummaryPageContentByTagFilter(ScenarioSummaryPageCollection scenarioSummaryPageCollection, Tag tag) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.scenarioSummaryPageRenderer.getRenderedContentByTagFilter(scenarioSummaryPageCollection, this.templateConfiguration.getTemplate("scenario-summary"), tag));
    }

    String getRenderedScenarioSummaryPageContentByFeatureFilter(ScenarioSummaryPageCollection scenarioSummaryPageCollection, Feature feature) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.scenarioSummaryPageRenderer.getRenderedContentByFeatureFilter(scenarioSummaryPageCollection, this.templateConfiguration.getTemplate("scenario-summary"), feature));
    }

    String getRenderedScenarioDetailPageContent(DetailPageCollection detailPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.scenarioDetailPageRenderer.getRenderedContent(detailPageCollection, this.templateConfiguration.getTemplate("scenario-detail")));
    }

    String getRenderedTagSummaryPageContent(TagSummaryPageCollection tagSummaryPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.tagSummaryPageRenderer.getRenderedContent(tagSummaryPageCollection, this.templateConfiguration.getTemplate("tag-summary")));
    }

    String getRenderedFeatureSummaryPageContent(FeatureSummaryPageCollection featureSummaryPageCollection) throws CluecumberPluginException {
        return RenderingUtils.prettifyHtml(this.featureSummaryPageRenderer.getRenderedContent(featureSummaryPageCollection, this.templateConfiguration.getTemplate("feature-summary")));
    }
}

