/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.pojos.pagecollections;

import com.trivago.rta.constants.Status;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.rendering.RenderingUtils;
import com.trivago.rta.rendering.pages.pojos.CustomParameter;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.PageCollection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class ScenarioSummaryPageCollection
extends PageCollection {
    private List<Report> reports = new ArrayList<Report>();
    private List<CustomParameter> customParameters;
    private Tag tagFilter;
    private Feature featureFilter;

    public ScenarioSummaryPageCollection() {
        super("Scenario Summary");
    }

    public List<Report> getReports() {
        return this.reports;
    }

    public List<Report> clearReports() {
        this.reports = new ArrayList<Report>();
        return this.reports;
    }

    public void addReports(Report[] reportList) {
        if (reportList == null) {
            return;
        }
        this.reports.addAll(Arrays.asList(reportList));
    }

    public int getTotalNumberOfScenarios() {
        return this.reports.stream().map(Report::getElements).mapToInt(elements -> (int)elements.stream().filter(Element::isScenario).count()).sum();
    }

    public boolean hasFailedScenarios() {
        return this.getTotalNumberOfFailedScenarios() > 0;
    }

    public boolean hasPassedScenarios() {
        return this.getTotalNumberOfPassedScenarios() > 0;
    }

    public boolean hasSkippedScenarios() {
        return this.getTotalNumberOfSkippedScenarios() > 0;
    }

    public int getTotalNumberOfPassedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.PASSED);
    }

    public int getTotalNumberOfFailedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.FAILED);
    }

    public int getTotalNumberOfSkippedScenarios() {
        return this.getNumberOfScenariosWithStatus(Status.SKIPPED);
    }

    private int getNumberOfScenariosWithStatus(Status status) {
        return this.reports.stream().mapToInt(report -> (int)report.getElements().stream().filter(element -> element.getStatus().equals((Object)status)).count()).sum();
    }

    public long getTotalDuration() {
        long totalDurationMicroseconds = 0L;
        for (Report report : this.reports) {
            totalDurationMicroseconds += report.getTotalDuration();
        }
        return totalDurationMicroseconds;
    }

    public String getTotalDurationString() {
        return RenderingUtils.convertMicrosecondsToTimeString(this.getTotalDuration());
    }

    public void setCustomParameters(List<CustomParameter> customParameters) {
        this.customParameters = customParameters;
    }

    public List<CustomParameter> getCustomParameters() {
        return this.customParameters;
    }

    public boolean hasCustomParameters() {
        return this.customParameters != null && !this.customParameters.isEmpty();
    }

    public Tag getTagFilter() {
        return this.tagFilter;
    }

    public void setTagFilter(Tag tagFilter) {
        this.tagFilter = tagFilter;
    }

    public Feature getFeatureFilter() {
        return this.featureFilter;
    }

    public void setFeatureFilter(Feature featureFilter) {
        this.featureFilter = featureFilter;
    }
}

