/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.pojos.pagecollections;

import com.trivago.rta.constants.Status;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.rendering.pages.pojos.ResultCount;
import com.trivago.rta.rendering.pages.pojos.pagecollections.SummaryPageCollection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TagSummaryPageCollection
extends SummaryPageCollection {
    private Map<Tag, ResultCount> tagResultCounts;

    public TagSummaryPageCollection(List<Report> reports) {
        super("Tag Summary");
        this.calculateTagResultCounts(reports);
    }

    public Map<Tag, ResultCount> getTagResultCounts() {
        return this.tagResultCounts;
    }

    public Set<Tag> getTags() {
        return this.tagResultCounts.keySet();
    }

    public int getTotalNumberOfTags() {
        return this.tagResultCounts.size();
    }

    public int getTotalNumberOfPassedTags() {
        return this.getNumberOfResultsWithStatus(this.tagResultCounts.values(), Status.PASSED);
    }

    public int getTotalNumberOfFailedTags() {
        return this.getNumberOfResultsWithStatus(this.tagResultCounts.values(), Status.FAILED);
    }

    public int getTotalNumberOfSkippedTags() {
        return this.getNumberOfResultsWithStatus(this.tagResultCounts.values(), Status.SKIPPED);
    }

    private void calculateTagResultCounts(List<Report> reports) {
        if (reports == null) {
            return;
        }
        this.tagResultCounts = new HashMap<Tag, ResultCount>();
        for (Report report : reports) {
            for (Element element : report.getElements()) {
                for (Tag tag : element.getTags()) {
                    ResultCount tagResultCount = this.tagResultCounts.getOrDefault(tag, new ResultCount());
                    this.updateResultCount(tagResultCount, element.getStatus());
                    this.tagResultCounts.put(tag, tagResultCount);
                }
            }
        }
    }
}

