/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.renderers;

import be.ceau.chart.BarChart;
import be.ceau.chart.data.BarData;
import be.ceau.chart.dataset.BarDataset;
import be.ceau.chart.dataset.Dataset;
import be.ceau.chart.options.BarOptions;
import be.ceau.chart.options.scales.BarScale;
import be.ceau.chart.options.scales.XAxis;
import be.ceau.chart.options.ticks.LinearTicks;
import be.ceau.chart.options.ticks.Ticks;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Step;
import com.trivago.rta.rendering.pages.pojos.pagecollections.DetailPageCollection;
import com.trivago.rta.rendering.pages.renderers.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import javax.inject.Singleton;

@Singleton
public class ScenarioDetailPageRenderer
extends PageRenderer {
    public String getRenderedContent(DetailPageCollection detailPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(detailPageCollection);
        return this.processedContent(template, detailPageCollection);
    }

    private void addChartJsonToReportDetails(DetailPageCollection detailPageCollection) {
        BarDataset barDataSet = new BarDataset();
        BarData barData = new BarData();
        int stepCounter = 1;
        for (Step step : detailPageCollection.getElement().getSteps()) {
            barData.addLabel("Step " + stepCounter);
            barDataSet.addData((double)step.getResult().getDurationInMilliseconds());
            barDataSet.addBackgroundColor(ChartColor.getChartColorByStatus(step.getStatus()));
            ++stepCounter;
        }
        barDataSet.setLabel("Step runtime");
        barData.addDataset((Dataset)barDataSet);
        BarScale barScale = new BarScale();
        ArrayList<XAxis> xAxisList = new ArrayList<XAxis>();
        xAxisList.add(new XAxis().setTicks((Ticks)new LinearTicks().setMin(0)));
        barScale.setxAxes(xAxisList);
        BarOptions barOptions = new BarOptions().setScales(barScale);
        detailPageCollection.getReportDetails().setChartJson(new BarChart(barData, barOptions).toJson());
    }
}

