/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.renderers;

import be.ceau.chart.PieChart;
import be.ceau.chart.color.Color;
import be.ceau.chart.data.PieData;
import be.ceau.chart.dataset.Dataset;
import be.ceau.chart.dataset.PieDataset;
import be.ceau.chart.options.PieOptions;
import com.rits.cloning.Cloner;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.constants.Status;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Element;
import com.trivago.rta.json.pojo.Report;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.properties.PropertyManager;
import com.trivago.rta.rendering.pages.pojos.CustomParameter;
import com.trivago.rta.rendering.pages.pojos.Feature;
import com.trivago.rta.rendering.pages.pojos.pagecollections.ScenarioSummaryPageCollection;
import com.trivago.rta.rendering.pages.renderers.PageRenderer;
import freemarker.template.Template;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class ScenarioSummaryPageRenderer
extends PageRenderer {
    private PropertyManager propertyManager;
    private Cloner cloner;

    @Inject
    public ScenarioSummaryPageRenderer(PropertyManager propertyManager) {
        this.propertyManager = propertyManager;
        this.cloner = new Cloner();
    }

    public String getRenderedContent(ScenarioSummaryPageCollection scenarioSummaryPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(scenarioSummaryPageCollection);
        this.addCustomParametersToReportDetails(scenarioSummaryPageCollection);
        return this.processedContent(template, scenarioSummaryPageCollection);
    }

    public String getRenderedContentByTagFilter(ScenarioSummaryPageCollection scenarioSummaryPageCollection, Template template, Tag tag) throws CluecumberPluginException {
        ScenarioSummaryPageCollection scenarioSummaryPageCollectionClone = (ScenarioSummaryPageCollection)this.cloner.deepClone((Object)scenarioSummaryPageCollection);
        scenarioSummaryPageCollectionClone.setTagFilter(tag);
        for (Report report : scenarioSummaryPageCollectionClone.getReports()) {
            ArrayList<Element> elements = new ArrayList<Element>();
            for (Element element : report.getElements()) {
                if (!element.getTags().contains(tag)) continue;
                elements.add(element);
            }
            report.setElements(elements);
        }
        this.addChartJsonToReportDetails(scenarioSummaryPageCollectionClone);
        return this.processedContent(template, scenarioSummaryPageCollectionClone);
    }

    public String getRenderedContentByFeatureFilter(ScenarioSummaryPageCollection scenarioSummaryPageCollection, Template template, Feature feature) throws CluecumberPluginException {
        ScenarioSummaryPageCollection scenarioSummaryPageCollectionClone = (ScenarioSummaryPageCollection)this.cloner.deepClone((Object)scenarioSummaryPageCollection);
        scenarioSummaryPageCollectionClone.setFeatureFilter(feature);
        ArrayList<Report> reports = new ArrayList<Report>();
        for (Report report : scenarioSummaryPageCollectionClone.getReports()) {
            if (report.getFeatureIndex() != feature.getIndex()) continue;
            reports.add(report);
        }
        Report[] reportArray = reports.toArray(new Report[0]);
        scenarioSummaryPageCollectionClone.clearReports();
        scenarioSummaryPageCollectionClone.addReports(reportArray);
        this.addChartJsonToReportDetails(scenarioSummaryPageCollectionClone);
        return this.processedContent(template, scenarioSummaryPageCollectionClone);
    }

    private void addChartJsonToReportDetails(ScenarioSummaryPageCollection scenarioSummaryPageCollection) {
        PieDataset pieDataset = new PieDataset();
        pieDataset.setData(new int[]{scenarioSummaryPageCollection.getTotalNumberOfPassedScenarios(), scenarioSummaryPageCollection.getTotalNumberOfFailedScenarios(), scenarioSummaryPageCollection.getTotalNumberOfSkippedScenarios()});
        Color passedColor = ChartColor.getChartColorByStatus(Status.PASSED);
        Color failedColor = ChartColor.getChartColorByStatus(Status.FAILED);
        Color skippedColor = ChartColor.getChartColorByStatus(Status.SKIPPED);
        pieDataset.addBackgroundColors(new Color[]{passedColor, failedColor, skippedColor});
        PieData pieData = new PieData();
        pieData.addDataset((Dataset)pieDataset);
        pieData.addLabels(new String[]{Status.PASSED.getStatusString(), Status.FAILED.getStatusString(), Status.SKIPPED.getStatusString()});
        PieOptions pieOptions = new PieOptions();
        scenarioSummaryPageCollection.getReportDetails().setChartJson(new PieChart(pieData, pieOptions).toJson());
    }

    private void addCustomParametersToReportDetails(ScenarioSummaryPageCollection scenarioSummaryPageCollection) {
        Map<String, String> customParameterMap = this.propertyManager.getCustomParameters();
        if (customParameterMap == null || customParameterMap.isEmpty()) {
            return;
        }
        ArrayList<CustomParameter> customParameters = new ArrayList<CustomParameter>();
        for (Map.Entry<String, String> stringStringEntry : customParameterMap.entrySet()) {
            String key = stringStringEntry.getKey().replace("_", " ");
            CustomParameter customParameter = new CustomParameter(key, stringStringEntry.getValue());
            customParameters.add(customParameter);
        }
        scenarioSummaryPageCollection.setCustomParameters(customParameters);
    }

    public static enum Filter {
        TAG,
        FEATURE;

    }
}

