/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.rendering.pages.renderers;

import be.ceau.chart.BarChart;
import be.ceau.chart.data.BarData;
import be.ceau.chart.dataset.BackgroundBorderHoverDataset;
import be.ceau.chart.dataset.BarDataset;
import be.ceau.chart.options.BarOptions;
import be.ceau.chart.options.scales.BarScale;
import be.ceau.chart.options.scales.XAxis;
import be.ceau.chart.options.scales.YAxis;
import be.ceau.chart.options.ticks.LinearTicks;
import be.ceau.chart.options.ticks.Ticks;
import com.trivago.rta.constants.ChartColor;
import com.trivago.rta.constants.Status;
import com.trivago.rta.exceptions.CluecumberPluginException;
import com.trivago.rta.json.pojo.Tag;
import com.trivago.rta.rendering.pages.pojos.ResultCount;
import com.trivago.rta.rendering.pages.pojos.pagecollections.TagSummaryPageCollection;
import com.trivago.rta.rendering.pages.renderers.PageRenderer;
import freemarker.template.Template;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Singleton;

@Singleton
public class TagSummaryPageRenderer
extends PageRenderer {
    public String getRenderedContent(TagSummaryPageCollection tagSummaryPageCollection, Template template) throws CluecumberPluginException {
        this.addChartJsonToReportDetails(tagSummaryPageCollection);
        return this.processedContent(template, tagSummaryPageCollection);
    }

    private void addChartJsonToReportDetails(TagSummaryPageCollection tagSummaryPageCollection) {
        ArrayList<BackgroundBorderHoverDataset> barDatasets = new ArrayList<BackgroundBorderHoverDataset>();
        ArrayList<BigDecimal> passed = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> failed = new ArrayList<BigDecimal>();
        ArrayList<BigDecimal> skipped = new ArrayList<BigDecimal>();
        int maxY = 0;
        for (Map.Entry<Tag, ResultCount> entry : tagSummaryPageCollection.getTagResultCounts().entrySet()) {
            passed.add(BigDecimal.valueOf(entry.getValue().getPassed()));
            failed.add(BigDecimal.valueOf(entry.getValue().getFailed()));
            skipped.add(BigDecimal.valueOf(entry.getValue().getSkipped()));
            maxY = entry.getValue().getTotal();
        }
        barDatasets.add(((BarDataset)new BarDataset().setLabel("passed").setData(passed)).setBackgroundColor(ChartColor.getChartColorByStatus(Status.PASSED)));
        barDatasets.add(((BarDataset)new BarDataset().setLabel("failed").setData(failed)).setBackgroundColor(ChartColor.getChartColorByStatus(Status.FAILED)));
        barDatasets.add(((BarDataset)new BarDataset().setLabel("skipped").setData(skipped)).setBackgroundColor(ChartColor.getChartColorByStatus(Status.SKIPPED)));
        BarData barData = new BarData();
        barData.setDatasets(barDatasets);
        ArrayList<String> keys = new ArrayList<String>();
        for (Tag tag : tagSummaryPageCollection.getTagResultCounts().keySet()) {
            keys.add(tag.getName());
        }
        barData.setLabels(keys);
        BarOptions barOptions = new BarOptions();
        BarScale barScale = new BarScale();
        ArrayList<XAxis> xAxisList = new ArrayList<XAxis>();
        xAxisList.add(new XAxis().setStacked(Boolean.valueOf(true)).setTicks((Ticks)new LinearTicks().setMin(0)));
        barScale.setxAxes(xAxisList);
        ArrayList<YAxis> yAxisList = new ArrayList<YAxis>();
        yAxisList.add(new YAxis().setStacked(Boolean.valueOf(true)).setTicks((Ticks)new LinearTicks().setMin(0).setStepSize(maxY)));
        barScale.setyAxes(yAxisList);
        barOptions.setScales(barScale);
        String chartJson = new BarChart(barData, barOptions).toJson();
        tagSummaryPageCollection.getReportDetails().setChartJson(chartJson);
    }
}

