/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.cluecumber.rendering.pages.pojos;

import com.trivago.cluecumber.rendering.RenderingUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class Times {
    private List<FeatureTime> times = new ArrayList<FeatureTime>();

    public void addTime(long nanoseconds, int featureIndex) {
        this.times.add(new FeatureTime(nanoseconds, featureIndex));
    }

    private FeatureTime getMinimumFeatureTime() {
        Optional<FeatureTime> featureTime = this.times.stream().min(Comparator.comparingLong(ft -> ((FeatureTime)ft).time));
        return featureTime.orElseGet(() -> new FeatureTime(0L, -1));
    }

    private FeatureTime getMaximumFeatureTime() {
        Optional<FeatureTime> featureTime = this.times.stream().max(Comparator.comparingLong(ft -> ((FeatureTime)ft).time));
        return featureTime.orElseGet(() -> new FeatureTime(0L, -1));
    }

    public String getMinimumTimeString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getMinimumFeatureTime().time);
    }

    public int getMinimumTimeScenarioIndex() {
        return this.getMinimumFeatureTime().scenarioIndex;
    }

    public String getMaximumTimeString() {
        return RenderingUtils.convertNanosecondsToTimeString(this.getMaximumFeatureTime().time);
    }

    public int getMaximumTimeScenarioIndex() {
        return this.getMaximumFeatureTime().scenarioIndex;
    }

    public String getAverageTimeString() {
        return RenderingUtils.convertNanosecondsToTimeString((long)this.times.stream().mapToLong(v -> ((FeatureTime)v).time).average().orElse(0.0));
    }

    class FeatureTime {
        private final long time;
        private final int scenarioIndex;

        FeatureTime(long time, int scenarioIndex) {
            this.time = time;
            this.scenarioIndex = scenarioIndex;
        }
    }
}

