/*
 * Decompiled with CFR 0.152.
 */
package com.trivago.rta.constants;

import com.trivago.rta.constants.Status;

public enum ChartColor {
    PASSED(40, 167, 69),
    FAILED(220, 53, 69),
    SKIPPED(255, 193, 7);

    private static final String COLOR_FORMAT = "rgba(%d, %d, %d, 1.000)";
    private final int r;
    private final int g;
    private final int b;

    private ChartColor(int r, int g, int b) {
        this.r = r;
        this.g = g;
        this.b = b;
    }

    public static String getChartColorStringByStatus(Status status) {
        switch (status) {
            case FAILED: {
                return String.format(COLOR_FORMAT, ChartColor.FAILED.r, ChartColor.FAILED.g, ChartColor.FAILED.b);
            }
            case SKIPPED: {
                return String.format(COLOR_FORMAT, ChartColor.SKIPPED.r, ChartColor.SKIPPED.g, ChartColor.SKIPPED.b);
            }
        }
        return String.format(COLOR_FORMAT, ChartColor.PASSED.r, ChartColor.PASSED.g, ChartColor.PASSED.b);
    }
}

